/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.capability.item.energy;

import meldexun.better_diving.capability.energy.CapabilityEnergyStorageProvider;
import meldexun.better_diving.capability.energy.IEnergyStorageExtended;
import meldexun.better_diving.item.ItemEnergyStorage;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class CapabilityEnergyStorageItem
implements IEnergyStorageExtended {
    private final ItemStack stack;

    public CapabilityEnergyStorageItem() {
        this.stack = ItemStack.field_190927_a;
    }

    public CapabilityEnergyStorageItem(ItemStack stack) {
        this.stack = stack;
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        if (!this.stack.func_77978_p().func_74764_b(CapabilityEnergyStorageProvider.LOCATION_ENERGY_STORAGE.toString())) {
            this.setEnergy(this.getMaxEnergyStored());
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxReceive(), maxReceive));
        if (!simulate) {
            this.setEnergy(this.getEnergyStored() + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxExtract(), maxExtract));
        if (!simulate) {
            this.setEnergy(this.getEnergyStored() - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        if (this.stack.func_77942_o()) {
            return this.stack.func_77978_p().func_74762_e(CapabilityEnergyStorageProvider.LOCATION_ENERGY_STORAGE.toString());
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        if (this.stack.func_77973_b() instanceof ItemEnergyStorage) {
            return ((ItemEnergyStorage)this.stack.func_77973_b()).getCapacity();
        }
        return 0;
    }

    public boolean canExtract() {
        return this.getMaxExtract() > 0;
    }

    public boolean canReceive() {
        return this.getMaxReceive() > 0;
    }

    @Override
    public void setEnergy(int energy) {
        if (this.stack.func_77942_o()) {
            this.stack.func_77978_p().func_74768_a(CapabilityEnergyStorageProvider.LOCATION_ENERGY_STORAGE.toString(), MathHelper.func_76125_a((int)energy, (int)0, (int)this.getMaxEnergyStored()));
        }
    }

    @Override
    public int getEnergyPercent() {
        return (int)(100.0 * (double)this.getEnergyStored() / (double)this.getMaxEnergyStored());
    }

    public int getMaxReceive() {
        if (this.stack.func_77973_b() instanceof ItemEnergyStorage) {
            return ((ItemEnergyStorage)this.stack.func_77973_b()).getMaxReceive();
        }
        return 0;
    }

    public int getMaxExtract() {
        if (this.stack.func_77973_b() instanceof ItemEnergyStorage) {
            return ((ItemEnergyStorage)this.stack.func_77973_b()).getMaxExtract();
        }
        return 0;
    }
}

