/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.client.event;

import java.nio.FloatBuffer;
import meldexun.better_diving.capability.diving.CapabilityDivingAttributesProvider;
import meldexun.better_diving.capability.diving.ICapabilityDivingAttributes;
import meldexun.better_diving.client.renderer.entity.RenderPlayerCustom;
import meldexun.better_diving.entity.EntitySeamoth;
import meldexun.better_diving.init.ModItems;
import meldexun.better_diving.integration.ArtemisLib;
import meldexun.better_diving.item.AbstractItemDivingGear;
import meldexun.better_diving.util.BetterDivingConfig;
import meldexun.better_diving.util.EntityHelper;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="better_diving", value={Side.CLIENT})
public class ClientEventHandler {
    private static float prevRotationPitch;
    private static float rotationPitch;
    private static float prevRenderYawOffset;
    private static float renderYawOffset;
    private static boolean movementInputSneak;
    private static RenderPlayer playerRenderer;
    private static RenderPlayer playerRendererSlim;

    private ClientEventHandler() {
    }

    @SubscribeEvent
    public static void hideWaterOverlay(RenderBlockOverlayEvent event) {
        EntityPlayer player = event.getPlayer();
        if (BetterDivingConfig.getInstance().modules.visionUnderWater && BetterDivingConfig.getInstance().client.hideWaterOverlay && event.getBlockForOverlay().func_177230_c() == Blocks.field_150355_j && (((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_77973_b() instanceof AbstractItemDivingGear || player.func_184187_bx() instanceof EntitySeamoth)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void setupFog(EntityViewRenderEvent.FogDensity event) {
        Entity entity = event.getEntity();
        if (BetterDivingConfig.getInstance().modules.visionUnderWater && event.getState().func_185904_a() == Material.field_151586_h && event.getEntity() instanceof EntityPlayer && !((EntityPlayer)event.getEntity()).func_70644_a(MobEffects.field_76440_q)) {
            long time = (entity.field_70170_p.func_72820_D() + 1450L) % 24000L;
            int blocksUnderwater = EntityHelper.blocksUnderWater(event.getEntity());
            if (BetterDivingConfig.getInstance().client.fogSettings.fogColorEnabled) {
                ClientEventHandler.setupFogColor(entity.field_70170_p, time, blocksUnderwater);
            }
            if (BetterDivingConfig.getInstance().client.fogSettings.fogDensityEnabled) {
                ClientEventHandler.setupFogDensity(entity.field_70170_p, time, blocksUnderwater);
            }
        }
    }

    public static void setupFogColor(World world, double time, double blocksUnderwater) {
        double[] color = BetterDivingConfig.getInstance().client.fogSettings.fogColor;
        double[] colorNight = BetterDivingConfig.getInstance().client.fogSettings.fogColorNight;
        double[] colorBlocksUnderWater = BetterDivingConfig.getInstance().client.fogSettings.fogColorBlocksUnderWater;
        double red = color[0];
        double green = color[1];
        double blue = color[2];
        double d = 0.0;
        if (time >= 0.0 && time <= 1900.0) {
            d = 1.0 - time / 1900.0;
        } else if (time > 1900.0 && time <= 13067.0) {
            d = 0.0;
        } else if (time > 13067.0 && time <= 15250.0) {
            d = (time - 13067.0) / 2183.0;
        } else if (time > 15250.0 && time <= 24000.0) {
            d = 1.0;
        }
        red *= 1.0 + colorNight[0] * d;
        green *= 1.0 + colorNight[1] * d;
        blue *= 1.0 + colorNight[2] * d;
        red *= 1.0 + colorBlocksUnderWater[0] * blocksUnderwater;
        green *= 1.0 + colorBlocksUnderWater[1] * blocksUnderwater;
        blue *= 1.0 + colorBlocksUnderWater[2] * blocksUnderwater;
        red = MathHelper.func_151237_a((double)red, (double)0.0, (double)1.0);
        green = MathHelper.func_151237_a((double)green, (double)0.0, (double)1.0);
        blue = MathHelper.func_151237_a((double)blue, (double)0.0, (double)1.0);
        GL11.glFog((int)2918, (FloatBuffer)RenderHelper.func_74521_a((float)((float)red), (float)((float)green), (float)((float)blue), (float)1.0f));
    }

    public static void setupFogDensity(World world, double time, double blocksUnderwater) {
        double density = BetterDivingConfig.getInstance().client.fogSettings.fogDensity;
        double densityNight = BetterDivingConfig.getInstance().client.fogSettings.fogDensityNight;
        double densityBlocksUnderWater = BetterDivingConfig.getInstance().client.fogSettings.fogDensityBlocksUnderWater;
        double d = 0.0;
        if (time >= 0.0 && time <= 1900.0) {
            d = 1.0 - time / 1900.0;
        } else if (time > 1900.0 && time <= 13067.0) {
            d = 0.0;
        } else if (time > 13067.0 && time <= 15250.0) {
            d = (time - 13067.0) / 2183.0;
        } else if (time > 15250.0 && time <= 24000.0) {
            d = 1.0;
        }
        density *= 1.0 + densityNight * d;
        density *= 1.0 + densityBlocksUnderWater * blocksUnderwater;
        density = Math.max(density, 1.0E-4);
        GL11.glFogf((int)2914, (float)((float)density));
    }

    public static void registerRenderers() {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        playerRenderer = new RenderPlayerCustom(renderManager, false);
        playerRendererSlim = new RenderPlayerCustom(renderManager, true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderPlayerEventPre(RenderPlayerEvent.Pre event) {
        if (!BetterDivingConfig.getInstance().modules.visionUnderWater || !BetterDivingConfig.getInstance().client.customPlayerModel) {
            return;
        }
        double x = event.getX();
        double y = event.getY();
        double z = event.getZ();
        float partialTicks = event.getPartialRenderTick();
        EntityPlayer player = event.getEntityPlayer();
        ICapabilityDivingAttributes idiving = (ICapabilityDivingAttributes)player.getCapability(CapabilityDivingAttributesProvider.DIVING_ATTRIBUTES, null);
        if (player.func_184187_bx() instanceof EntitySeamoth) {
            double sinYaw = Math.sin(Math.toRadians(player.field_70177_z));
            double cosYaw = Math.cos(Math.toRadians(player.field_70177_z));
            GL11.glPushMatrix();
            if (ArtemisLib.loaded) {
                GL11.glTranslated((double)x, (double)(y + 0.8), (double)z);
                GL11.glRotated((double)player.field_70125_A, (double)cosYaw, (double)0.0, (double)sinYaw);
                GL11.glTranslated((double)(-x), (double)(-y - 0.8 - 0.4 * ArtemisLib.getHeightScale(player)), (double)(-z));
                ArtemisLib.rescale(player);
            } else {
                GL11.glTranslated((double)x, (double)(y + 0.8), (double)z);
                GL11.glRotated((double)player.field_70125_A, (double)cosYaw, (double)0.0, (double)sinYaw);
                GL11.glTranslated((double)(-x), (double)(-y - 1.2), (double)(-z));
            }
            prevRotationPitch = player.field_70127_C;
            rotationPitch = player.field_70125_A;
            prevRenderYawOffset = player.field_70760_ar;
            renderYawOffset = player.field_70761_aq;
            player.func_70031_b(false);
            player.func_70095_a(false);
            player.field_70127_C = 0.0f;
            player.field_70125_A = 0.0f;
            player.field_70760_ar = MathHelper.func_76131_a((float)player.field_70760_ar, (float)(player.field_70126_B - 10.0f), (float)(player.field_70126_B + 10.0f));
            player.field_70761_aq = MathHelper.func_76131_a((float)player.field_70761_aq, (float)(player.field_70177_z - 10.0f), (float)(player.field_70177_z + 10.0f));
            if (player instanceof EntityPlayerSP) {
                movementInputSneak = ((EntityPlayerSP)player).field_71158_b.field_78899_d;
                ((EntityPlayerSP)player).field_71158_b.field_78899_d = false;
            }
        } else if (idiving.getDivingTick() > 0.0f || player.func_184614_ca().func_77973_b() == ModItems.SEAGLIDE) {
            double divingTick = MathHelper.func_151238_b((double)idiving.getPrevDivingTick(), (double)idiving.getDivingTick(), (double)partialTicks);
            double divingTickHorizontal = MathHelper.func_151238_b((double)idiving.getPrevDivingTickHorizontal(), (double)idiving.getDivingTickHorizontal(), (double)partialTicks);
            double divingTickVertical = MathHelper.func_151238_b((double)idiving.getPrevDivingTickVertical(), (double)idiving.getDivingTickVertical(), (double)partialTicks);
            float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            if (divingTickVertical > 0.0) {
                pitch += (-90.0f - pitch) * 0.5f * (float)divingTickVertical;
            } else if (divingTickVertical < 0.0) {
                pitch += (90.0f - pitch) * 0.5f * (float)(-divingTickVertical);
            }
            pitch += idiving.isDiving() ? 90.0f : 60.0f;
            float yaw = (float)divingTickHorizontal * 45.0f;
            double sinYaw = Math.sin(Math.toRadians(player.field_70177_z));
            double cosYaw = Math.cos(Math.toRadians(player.field_70177_z));
            GL11.glPushMatrix();
            if (ArtemisLib.loaded) {
                GL11.glTranslated((double)x, (double)(y + divingTick * 0.3 * ArtemisLib.getHeightScale(player)), (double)z);
                GL11.glRotated((double)(divingTick * (double)pitch), (double)cosYaw, (double)0.0, (double)sinYaw);
                GL11.glRotated((double)(divingTick * (double)yaw), (double)sinYaw, (double)0.0, (double)(-cosYaw));
                GL11.glTranslated((double)(-x), (double)(-y - divingTick * 0.9 * ArtemisLib.getHeightScale(player)), (double)(-z));
                ArtemisLib.rescale(player);
            } else {
                GL11.glTranslated((double)x, (double)(y + divingTick * 0.3), (double)z);
                GL11.glRotated((double)(divingTick * (double)pitch), (double)cosYaw, (double)0.0, (double)sinYaw);
                GL11.glRotated((double)(divingTick * (double)yaw), (double)sinYaw, (double)0.0, (double)(-cosYaw));
                GL11.glTranslated((double)(-x), (double)(-y - divingTick * 0.9), (double)(-z));
            }
            prevRotationPitch = player.field_70127_C;
            rotationPitch = player.field_70125_A;
            prevRenderYawOffset = player.field_70760_ar;
            renderYawOffset = player.field_70761_aq;
            player.func_70031_b(false);
            player.func_70095_a(false);
            player.field_70127_C += (float)divingTick * (-60.0f - player.field_70127_C);
            player.field_70125_A += (float)divingTick * (-60.0f - player.field_70125_A);
            float f = 75.0f - 60.0f * (float)divingTick;
            player.field_70760_ar = MathHelper.func_76131_a((float)player.field_70760_ar, (float)(player.field_70126_B - f), (float)(player.field_70126_B + f));
            player.field_70761_aq = MathHelper.func_76131_a((float)player.field_70761_aq, (float)(player.field_70177_z - f), (float)(player.field_70177_z + f));
            if (player instanceof EntityPlayerSP) {
                movementInputSneak = ((EntityPlayerSP)player).field_71158_b.field_78899_d;
                ((EntityPlayerSP)player).field_71158_b.field_78899_d = false;
            }
        }
    }

    private static Render getPlayerRender(AbstractClientPlayer player) {
        return player.func_175154_l().equals("slim") ? playerRendererSlim : playerRenderer;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRenderPlayerEventPost(RenderPlayerEvent.Post event) {
        if (!BetterDivingConfig.getInstance().modules.visionUnderWater || !BetterDivingConfig.getInstance().client.customPlayerModel) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ICapabilityDivingAttributes idiving = (ICapabilityDivingAttributes)player.getCapability(CapabilityDivingAttributesProvider.DIVING_ATTRIBUTES, null);
        if (player.func_184187_bx() instanceof EntitySeamoth || idiving.getDivingTick() > 0.0f || player.func_184614_ca().func_77973_b() == ModItems.SEAGLIDE) {
            GL11.glPopMatrix();
            player.field_70127_C = prevRotationPitch;
            player.field_70125_A = rotationPitch;
            player.field_70760_ar = prevRenderYawOffset;
            player.field_70761_aq = renderYawOffset;
            if (player instanceof EntityPlayerSP) {
                ((EntityPlayerSP)player).field_71158_b.field_78899_d = movementInputSneak;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!BetterDivingConfig.getInstance().modules.visionUnderWater || !BetterDivingConfig.getInstance().client.customPlayerModel) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && event.player.func_70090_H() && !event.player.func_184218_aH()) {
            double d1 = event.player.field_70165_t - event.player.field_70169_q;
            double d2 = event.player.field_70161_v - event.player.field_70166_s;
            double d3 = event.player.field_70163_u - event.player.field_70167_r;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2 + d3 * d3)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            event.player.field_70721_aZ = event.player.field_184618_aE;
            event.player.field_184619_aG -= event.player.field_184618_aE;
            event.player.field_70721_aZ += (f2 - event.player.field_70721_aZ) * 0.4f;
            event.player.field_184619_aG += event.player.field_70721_aZ;
        }
    }
}

