/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.client.gui;

import meldexun.better_diving.capability.diving.CapabilityDivingAttributesProvider;
import meldexun.better_diving.capability.diving.ICapabilityDivingAttributes;
import meldexun.better_diving.client.util.GuiHelper;
import meldexun.better_diving.util.BetterDivingConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiOxygen
extends Gui {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("better_diving", "textures/gui/oxygen/oxygen_alternative_background.png");
    private static final ResourceLocation BAR = new ResourceLocation("better_diving", "textures/gui/oxygen/oxygen_alternative_bar.png");
    private static final ResourceLocation FRAME = new ResourceLocation("better_diving", "textures/gui/oxygen/oxygen_alternative_frame.png");
    private static final ResourceLocation OXYGEN_BAR = new ResourceLocation("better_diving", "textures/gui/oxygen/oxygen_bar.png");
    private static final ResourceLocation OXYGEN_BUBBLES = new ResourceLocation("better_diving", "textures/gui/oxygen/oxygen_bubbles.png");
    private float partialTicks = 0.0f;
    private float prevPartialTicks = 0.0f;

    public void render() {
        this.updatePartialTicks();
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager textureManager = mc.func_110434_K();
        ScaledResolution scaled = new ScaledResolution(mc);
        FontRenderer fontRenderer = mc.field_71466_p;
        BetterDivingConfig config = BetterDivingConfig.getInstance();
        ICapabilityDivingAttributes idiving = (ICapabilityDivingAttributes)mc.field_71439_g.getCapability(CapabilityDivingAttributesProvider.DIVING_ATTRIBUTES, null);
        if (config.client.guiOxygenAlternative) {
            int air = (int)Math.round((double)idiving.getOxygenFromPlayer() / 20.0 / 3.0) * 3;
            double percent = idiving.getOxygenFromPlayerInPercent();
            int x = GuiHelper.getAnchorX(102, config.client.guiOxygenConfig);
            int y = GuiHelper.getAnchorY(21, config.client.guiOxygenConfig);
            textureManager.func_110577_a(BACKGROUND);
            GuiHelper.drawTexture(x, y, 0.0, 0.0, 102.0, 21.0, 1.0, 1.0);
            textureManager.func_110577_a(BAR);
            GuiHelper.drawTexture((double)x + 1.0 + 80.0 * (1.0 - percent), (double)y + 7.0, 1.0 - percent, 0.0, 80.0 * percent, 7.0, percent, 1.0);
            textureManager.func_110577_a(OXYGEN_BUBBLES);
            double offset = 2.0 * (double)this.partialTicks % 128.0 / 128.0;
            this.drawBubbles((double)x + 1.0, (double)y + 7.0, 0.0, offset, percent);
            offset = 2.5 * (double)this.partialTicks % 128.0 / 128.0;
            this.drawBubbles((double)x + 1.0, (double)y + 7.0, 20.0, offset + 0.45, percent);
            offset = 1.5 * (double)this.partialTicks % 128.0 / 128.0;
            this.drawBubbles((double)x + 1.0, (double)y + 7.0, 35.0, offset + 0.12, percent);
            offset = 2.0 * (double)this.partialTicks % 128.0 / 128.0;
            this.drawBubbles((double)x + 1.0, (double)y + 7.0, 55.0, offset + 0.68, percent);
            textureManager.func_110577_a(FRAME);
            GuiHelper.drawTexture(x, y, 0.0, 0.0, 102.0, 21.0, 1.0, 1.0);
            this.func_73732_a(fontRenderer, Integer.toString(air), x + 91, y + 11, Integer.parseInt("FFFFFF", 16));
            this.func_73732_a(fontRenderer, "O\u2082", x + 91, y + 2, Integer.parseInt("FFFFFF", 16));
        } else {
            int size = 37;
            int x = GuiHelper.getAnchorX(size, config.client.guiOxygenConfig);
            int y = GuiHelper.getAnchorY(size, config.client.guiOxygenConfig);
            int i = MathHelper.func_76125_a((int)scaled.func_78325_e(), (int)1, (int)9);
            boolean blend = GL11.glGetBoolean((int)3042);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            textureManager.func_110577_a(new ResourceLocation("better_diving", "textures/gui/oxygen/oxygen_background_" + i + ".png"));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GuiHelper.drawTexture(x, y, 0.0, 0.0, size, size, 1.0, 1.0);
            textureManager.func_110577_a(new ResourceLocation("better_diving", "textures/gui/oxygen/oxygen_center_" + i + ".png"));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GuiHelper.drawTexture(x, y, 0.0, 0.0, size, size, 1.0, 1.0);
            textureManager.func_110577_a(new ResourceLocation("better_diving", "textures/gui/oxygen/oxygen_foreground_" + i + ".png"));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GuiHelper.drawTexture(x, y, 0.0, 0.0, size, size, 1.0, 1.0);
            double percent = idiving.getOxygenFromPlayerInPercent();
            double xm = (double)x + (double)size / 2.0;
            double ym = (double)y + (double)size / 2.0;
            double sinP = Math.sin(percent * (Math.PI * 2));
            double cosP = Math.cos(percent * (Math.PI * 2));
            double innerRadius = 10.4;
            double outerRadius = 14.2;
            double middleRadius = (innerRadius + outerRadius) / 2.0;
            double smallRadius = outerRadius - middleRadius;
            double texInnerRadius = innerRadius / (double)size;
            double texOuterRadius = outerRadius / (double)size;
            double texMiddleRadius = (texInnerRadius + texOuterRadius) / 2.0;
            double texSmallRadius = texOuterRadius - texMiddleRadius;
            GL11.glDisable((int)3553);
            GL11.glColor4d((double)0.2, (double)0.65, (double)0.1, (double)1.0);
            GL11.glLineWidth((float)1.0f);
            GuiOxygen.drawSmoothCircle(xm, ym - middleRadius, smallRadius, 45, 0.5, 0.5);
            GuiOxygen.drawSmoothCircle(xm + sinP * middleRadius, ym - cosP * middleRadius, smallRadius, 45, 0.5, percent);
            GL11.glEnable((int)3553);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            textureManager.func_110577_a(OXYGEN_BAR);
            GuiOxygen.drawTexturedCircle(xm, ym - middleRadius, smallRadius, 0.5, 0.5 - texMiddleRadius, texSmallRadius, 45, 0.5, -0.5);
            GuiOxygen.drawTexturedCircle(xm + sinP * middleRadius, ym - cosP * middleRadius, smallRadius, 0.5 + sinP * texMiddleRadius, 0.5 - cosP * texMiddleRadius, texSmallRadius, 45, 0.5, -percent);
            GuiOxygen.drawTexturedRing(xm, ym, innerRadius, outerRadius, 0.5, 0.5, texInnerRadius, texOuterRadius, 180, percent, 0.0);
            GL11.glDisable((int)3553);
            GL11.glColor4d((double)0.2, (double)0.65, (double)0.1, (double)1.0);
            GL11.glLineWidth((float)1.0f);
            GuiOxygen.drawSmoothCircle(xm, ym, innerRadius, 180, percent, 0.0);
            GuiOxygen.drawSmoothCircle(xm, ym, outerRadius, 180, percent, 0.0);
            GL11.glEnable((int)3553);
            double offset = 4.0 * (double)this.partialTicks % 128.0 / 128.0;
            double d1 = innerRadius * 8.0 / 128.0;
            double d2 = outerRadius * 8.0 / 128.0;
            double d3 = (d2 + d1) / 2.0;
            double d4 = d2 - d3;
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)(1.0 - Math.pow(percent, 4.0)));
            textureManager.func_110577_a(OXYGEN_BUBBLES);
            GuiOxygen.drawTexturedCircle(xm, ym - middleRadius, smallRadius, d2, d2 - d3 + offset, d4, 45, 0.5, -0.5);
            GuiOxygen.drawTexturedCircle(xm + sinP * middleRadius, ym - cosP * middleRadius, smallRadius, d2 + sinP * d3, d2 - cosP * d3 + offset, d4, 45, 0.5, -percent);
            GuiOxygen.drawTexturedRing(xm, ym, innerRadius, outerRadius, d2, d2 + offset, d1, d2, 180, percent, 0.0);
            int air = (int)Math.round((double)idiving.getOxygenFromPlayer() / 20.0 / 3.0) * 3;
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glPushMatrix();
            double scale = 0.75;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glTranslated((double)(xm / scale), (double)(ym / scale), (double)0.0);
            this.func_73732_a(fontRenderer, Integer.toString(air), 0, 0, Integer.parseInt("FFFFFF", 16));
            this.func_73732_a(fontRenderer, "O\u2082", 0, -9, Integer.parseInt("FFFFFF", 16));
            GL11.glPopMatrix();
            if (!blend) {
                GL11.glDisable((int)3042);
            }
            GL11.glPopMatrix();
        }
    }

    public void updatePartialTicks() {
        Minecraft mc = Minecraft.func_71410_x();
        float f = mc.func_184121_ak() - this.prevPartialTicks;
        if (f <= 0.0f) {
            f += 1.0f;
        }
        this.partialTicks += f;
        this.prevPartialTicks = mc.func_184121_ak();
    }

    public void drawBubbles(double x, double y, double xOffset, double vOffset, double percent) {
        double width = 21.333333333333332;
        double height = 8.0;
        xOffset = MathHelper.func_151237_a((double)xOffset, (double)0.0, (double)(80.0 - width));
        percent = MathHelper.func_151237_a((double)(percent * 80.0 / width - (80.0 - width - xOffset) / width), (double)0.0, (double)1.0);
        GuiHelper.drawTexture(x + xOffset + width * (1.0 - percent), y, 1.0 - percent, vOffset, width * percent, height, percent, 0.375);
    }

    public static void drawTexturedRing(double x, double y, double innerRadius, double outerRadius, double u, double v, double texInnerRadius, double texOuterRadius, int sides, double percent, double startAngle) {
        double cos;
        double sin;
        double rad;
        GL11.glBegin((int)8);
        int i = 0;
        while ((double)i < percent * (double)sides) {
            rad = Math.PI * 2 * ((double)i / (double)sides + startAngle);
            sin = Math.sin(rad);
            cos = -Math.cos(rad);
            GL11.glTexCoord2d((double)(u + sin * texOuterRadius), (double)(v + cos * texOuterRadius));
            GL11.glVertex2d((double)(x + sin * outerRadius), (double)(y + cos * outerRadius));
            GL11.glTexCoord2d((double)(u + sin * texInnerRadius), (double)(v + cos * texInnerRadius));
            GL11.glVertex2d((double)(x + sin * innerRadius), (double)(y + cos * innerRadius));
            ++i;
        }
        rad = Math.PI * 2 * (percent + startAngle);
        sin = Math.sin(rad);
        cos = -Math.cos(rad);
        GL11.glTexCoord2d((double)(u + sin * texOuterRadius), (double)(v + cos * texOuterRadius));
        GL11.glVertex2d((double)(x + sin * outerRadius), (double)(y + cos * outerRadius));
        GL11.glTexCoord2d((double)(u + sin * texInnerRadius), (double)(v + cos * texInnerRadius));
        GL11.glVertex2d((double)(x + sin * innerRadius), (double)(y + cos * innerRadius));
        GL11.glEnd();
    }

    public static void drawTexturedCircle(double x, double y, double radius, double u, double v, double texRadius, int sides, double percent, double startAngle) {
        double cos;
        double sin;
        double rad;
        GL11.glBegin((int)6);
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex2d((double)x, (double)y);
        int i = 0;
        while ((double)i < percent * (double)sides) {
            rad = Math.PI * 2 * ((double)i / (double)sides + startAngle);
            sin = Math.sin(rad);
            cos = Math.cos(rad);
            GL11.glTexCoord2d((double)(u + sin * texRadius), (double)(v + cos * texRadius));
            GL11.glVertex2d((double)(x + sin * radius), (double)(y + cos * radius));
            ++i;
        }
        rad = Math.PI * 2 * (percent + startAngle);
        sin = Math.sin(rad);
        cos = Math.cos(rad);
        GL11.glTexCoord2d((double)(u + sin * texRadius), (double)(v + cos * texRadius));
        GL11.glVertex2d((double)(x + sin * radius), (double)(y + cos * radius));
        GL11.glEnd();
    }

    public static void drawSmoothCircle(double x, double y, double radius, int sides, double percent, double startAngle) {
        double cos;
        double sin;
        double rad;
        boolean blend = GL11.glGetBoolean((int)3042);
        boolean lineSmooth = GL11.glGetBoolean((int)2848);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glBegin((int)3);
        int i = 0;
        while ((double)i < percent * (double)sides) {
            rad = Math.PI * 2 * ((double)i / (double)sides + startAngle);
            sin = Math.sin(rad);
            cos = -Math.cos(rad);
            GL11.glVertex2d((double)(x + sin * radius), (double)(y + cos * radius));
            ++i;
        }
        rad = Math.PI * 2 * (percent + startAngle);
        sin = Math.sin(rad);
        cos = -Math.cos(rad);
        GL11.glVertex2d((double)(x + sin * radius), (double)(y + cos * radius));
        GL11.glEnd();
        if (!lineSmooth) {
            GL11.glDisable((int)2848);
        }
        if (!blend) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }
}

