/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import meldexun.better_diving.BetterDiving;
import meldexun.better_diving.client.audio.EntityFollowingSound;
import meldexun.better_diving.client.audio.SeamothEngineLoopSound;
import meldexun.better_diving.init.ModItems;
import meldexun.better_diving.init.ModSounds;
import meldexun.better_diving.item.ItemEnergyStorage;
import meldexun.better_diving.item.ItemPowerCell;
import meldexun.better_diving.network.packet.CPacketSyncSeamothInput;
import meldexun.better_diving.network.packet.SPacketSyncSeamothBattery;
import meldexun.better_diving.network.packet.SPacketSyncSeamothEnergy;
import meldexun.better_diving.proxy.ClientProxy;
import meldexun.better_diving.util.BetterDivingConfig;
import meldexun.better_diving.util.MovementHelper;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EntitySeamoth
extends Entity
implements IEntityAdditionalSpawnData {
    private int damage = 0;
    private boolean prevControlled = false;
    public boolean inputForward = false;
    public boolean inputRight = false;
    public boolean inputBack = false;
    public boolean inputLeft = false;
    public boolean inputUp = false;
    public boolean inputDown = false;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public float partialTicks = 0.0f;
    public boolean insideWater = false;
    @SideOnly(value=Side.CLIENT)
    public SeamothEngineLoopSound engineLoopSound;

    public EntitySeamoth(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.82f, 1.82f);
        this.field_70178_ae = true;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateEngineSound() {
        SoundHandler soundHandler;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.func_186711_a(SoundCategory.MASTER) > 0.0f && !(soundHandler = mc.func_147118_V()).func_147692_c((ISound)this.engineLoopSound)) {
            if (this.isPlayerSteering() && this.hasEnergy()) {
                int tick = this.engineLoopSound != null ? this.engineLoopSound.getTick() : 0;
                this.engineLoopSound = new SeamothEngineLoopSound(this);
                this.engineLoopSound.setTick(tick);
                soundHandler.func_147682_a((ISound)this.engineLoopSound);
            } else if (this.engineLoopSound != null) {
                this.engineLoopSound = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateControls() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.func_184179_bs() == mc.field_71439_g) {
            GameSettings settings = mc.field_71474_y;
            this.inputForward = settings.field_74351_w.func_151470_d();
            this.inputRight = settings.field_74366_z.func_151470_d();
            this.inputBack = settings.field_74368_y.func_151470_d();
            this.inputLeft = settings.field_74370_x.func_151470_d();
            this.inputUp = settings.field_74314_A.func_151470_d();
            this.inputDown = ClientProxy.keyBindSeamothDescend.func_151470_d();
            BetterDiving.network.sendToServer((IMessage)new CPacketSyncSeamothInput(this));
            this.prevControlled = true;
        } else if (this.prevControlled) {
            this.inputForward = false;
            this.inputRight = false;
            this.inputBack = false;
            this.inputLeft = false;
            this.inputUp = false;
            this.inputDown = false;
            BetterDiving.network.sendToServer((IMessage)new CPacketSyncSeamothInput(this));
            this.prevControlled = false;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70122_E = false;
        this.insideWater = this.func_70055_a(Material.field_151586_h);
        if (this.damage > 0) {
            --this.damage;
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateEngineSound();
            this.updateControls();
        }
        this.updateMotion();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if (player.func_184812_l_()) {
                this.func_70106_y();
                return true;
            }
            if (!this.func_184207_aI()) {
                this.damage += 20;
                if (this.damage > 30) {
                    this.func_70106_y();
                    ItemStack seamoth = this.toItemStack();
                    if (!player.func_191521_c(seamoth)) {
                        this.func_70099_a(seamoth, 0.0f);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                player.openGui((Object)BetterDiving.instance, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        if (!this.func_184207_aI()) {
            if (!this.field_70170_p.field_72995_K) {
                player.field_70177_z = this.field_70177_z;
                player.field_70125_A = this.field_70125_A;
                player.func_184220_m((Entity)this);
                this.syncBattery();
            } else {
                this.playEnterSound(player);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void playEnterSound(EntityPlayer player) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new EntityFollowingSound(this, ModSounds.SEAMOTH_ENTER));
    }

    public double func_70042_X() {
        return 0.36;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.updateRotation();
        entityToUpdate.field_70126_B = this.field_70177_z;
        entityToUpdate.field_70177_z = this.field_70177_z;
        entityToUpdate.field_70127_C = this.field_70125_A;
        entityToUpdate.field_70125_A = this.field_70125_A;
        if (entityToUpdate instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)entityToUpdate;
            entity.field_70758_at = this.field_70177_z;
            entity.field_70759_as = this.field_70177_z;
            entity.field_70760_ar = this.field_70177_z;
            entity.field_70761_aq = this.field_70177_z;
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.getBattery());
        buffer.writeInt(this.getEnergy());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setBattery(ByteBufUtils.readItemStack((ByteBuf)additionalData));
        this.setEnergy(additionalData.readInt());
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRotation() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.func_184179_bs() == mc.field_71439_g) {
            float f = mc.func_184121_ak() - this.partialTicks;
            if (f <= 0.0f) {
                f += 1.0f;
            }
            this.partialTicks = mc.func_184121_ak();
            if (this.field_70171_ac && this.getEnergy() > 0) {
                double d = (double)mc.field_71474_y.field_74341_c * 0.6 + 0.2;
                double d1 = d * d * d * 8.0;
                double deltaX = mc.field_71417_B.field_74377_a;
                double deltaY = -((double)mc.field_71417_B.field_74375_b);
                double d2 = MathHelper.func_151237_a((double)(deltaX * d1 * 0.06), (double)(-24.0 * (double)f), (double)(24.0 * (double)f));
                double d3 = MathHelper.func_151237_a((double)(deltaY * d1 * 0.06), (double)(-24.0 * (double)f), (double)(24.0 * (double)f));
                if (mc.field_71474_y.field_74338_d) {
                    d3 *= -1.0;
                }
                this.field_70177_z += (float)d2 * 0.5f;
                this.field_70125_A += (float)d3 * 0.5f;
                this.yaw += (float)d2 * 0.5f;
                this.pitch += (float)d3 * 0.5f;
            }
            if (Math.abs(this.yaw) > 0.01f) {
                this.field_70177_z += this.yaw * 0.5f * f;
                this.yaw *= 1.0f - 0.2f * f;
            } else {
                this.yaw = 0.0f;
            }
            if (Math.abs(this.pitch) > 0.01f) {
                this.field_70125_A += this.pitch * 0.5f * f;
                this.pitch *= 1.0f - 0.2f * f;
            } else {
                this.pitch = 0.0f;
            }
            this.field_70125_A = MathHelper.func_76131_a((float)this.field_70125_A, (float)-90.0f, (float)90.0f);
        }
    }

    public void updateMotion() {
        if (this.insideWater) {
            this.field_70159_w *= 0.95;
            this.field_70181_x *= 0.95;
            this.field_70179_y *= 0.95;
        } else {
            this.field_70159_w *= 0.99;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.99;
        }
        if (Math.abs(this.field_70159_w) < 0.001) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 0.001) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 0.001) {
            this.field_70179_y = 0.0;
        }
        if (!this.insideWater) {
            this.field_70181_x -= 0.015;
        }
        if (this.func_184179_bs() instanceof EntityPlayer && this.isPlayerSteering() && this.getEnergy() > 0) {
            if (this.field_70170_p.field_72995_K) {
                if (!BetterDivingConfig.getInstance().general.seamothEnergySyncPackets) {
                    this.extractEnergy(BetterDivingConfig.getInstance().divingValues.seamothEnergyUsage);
                }
            } else {
                this.extractEnergy(BetterDivingConfig.getInstance().divingValues.seamothEnergyUsage);
                if (BetterDivingConfig.getInstance().general.seamothEnergySyncPackets) {
                    this.syncEnergy();
                }
            }
            if (this.insideWater) {
                double d = BetterDivingConfig.getInstance().divingValues.seamothSpeed;
                float rotationYaw = this.field_70177_z;
                float rotationPitch = this.field_70125_A;
                float strafe = 0.0f;
                float forward = 0.0f;
                float up = 0.0f;
                if (this.inputForward) {
                    forward += 1.0f;
                }
                if (this.inputBack) {
                    forward -= 1.0f;
                }
                if (this.inputRight) {
                    strafe -= 1.0f;
                }
                if (this.inputLeft) {
                    strafe += 1.0f;
                }
                if (this.inputUp) {
                    up += 1.0f;
                }
                if (this.inputDown) {
                    up -= 1.0f;
                }
                if (this.inputForward && !this.inputBack) {
                    if (this.inputUp && !this.inputDown) {
                        rotationPitch = (rotationPitch - 90.0f) / 2.0f;
                        up = 0.0f;
                    } else if (this.inputDown && !this.inputUp) {
                        rotationPitch = (rotationPitch + 90.0f) / 2.0f;
                        up = 0.0f;
                    }
                } else if (this.inputBack && !this.inputForward) {
                    if (this.inputUp && !this.inputDown) {
                        rotationPitch = (rotationPitch + 90.0f) / 2.0f;
                        up = 0.0f;
                    } else if (this.inputDown && !this.inputUp) {
                        rotationPitch = (rotationPitch - 90.0f) / 2.0f;
                        up = 0.0f;
                    }
                    forward *= 0.45f;
                }
                MovementHelper.move3D(this, strafe, up, forward, d, rotationYaw, rotationPitch);
            }
        }
    }

    public boolean isPlayerSteering() {
        return this.inputForward != this.inputBack || this.inputLeft != this.inputRight || this.inputUp != this.inputDown;
    }

    public ItemStack toItemStack() {
        ItemStack stack = new ItemStack((Item)ModItems.SEAMOTH);
        ItemStackHandler itemStackHandler = (ItemStackHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        itemStackHandler.setStackInSlot(0, this.getBattery().func_77946_l());
        return stack;
    }

    public ItemStack getBattery() {
        return ((IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
    }

    public void setBattery(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemPowerCell) {
            ItemStackHandler itemStackHandler = (ItemStackHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            itemStackHandler.setStackInSlot(0, stack);
        }
    }

    public boolean hasEnergy() {
        ItemStack powerCell = this.getBattery();
        if (powerCell.func_77973_b() instanceof ItemPowerCell) {
            return ItemEnergyStorage.hasEnergy(powerCell);
        }
        return false;
    }

    public int getEnergy() {
        ItemStack powerCell = this.getBattery();
        if (powerCell.func_77973_b() instanceof ItemPowerCell) {
            return ItemEnergyStorage.getEnergy(powerCell);
        }
        return 0;
    }

    public boolean setEnergy(int energy) {
        ItemStack powerCell = this.getBattery();
        if (powerCell.func_77973_b() instanceof ItemPowerCell) {
            return ItemEnergyStorage.setEnergy(powerCell, energy);
        }
        return false;
    }

    public int getEnergyCapacity() {
        ItemStack powerCell = this.getBattery();
        if (powerCell.func_77973_b() instanceof ItemPowerCell) {
            return ItemEnergyStorage.getEnergyCapacity(powerCell);
        }
        return 0;
    }

    public int receiveEnergy(int amount) {
        ItemStack powerCell;
        if (amount > 0 && (powerCell = this.getBattery()).func_77973_b() instanceof ItemPowerCell) {
            return ItemEnergyStorage.receiveEnergy(powerCell, amount);
        }
        return 0;
    }

    public int extractEnergy(int amount) {
        ItemStack powerCell;
        if (amount > 0 && (powerCell = this.getBattery()).func_77973_b() instanceof ItemPowerCell) {
            return ItemEnergyStorage.extractEnergy(powerCell, amount);
        }
        return 0;
    }

    public void syncBattery() {
        if (!this.field_70170_p.field_72995_K && this.func_184179_bs() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.func_184179_bs();
            BetterDiving.network.sendTo((IMessage)new SPacketSyncSeamothBattery(this), (EntityPlayerMP)player);
        }
    }

    public void syncEnergy() {
        if (!this.field_70170_p.field_72995_K && this.func_184179_bs() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.func_184179_bs();
            BetterDiving.network.sendTo((IMessage)new SPacketSyncSeamothEnergy(this), (EntityPlayerMP)player);
        }
    }
}

