/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.entity.event;

import meldexun.better_diving.entity.EntitySeamoth;
import meldexun.better_diving.util.BetterDivingConfig;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="better_diving")
public class EntityEventHandler {
    private EntityEventHandler() {
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntity().func_184187_bx() instanceof EntitySeamoth && event.getSource().func_76364_f() != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (BetterDivingConfig.getInstance().general.itemEntityMovement && event.phase == TickEvent.Phase.END) {
            EntityEventHandler.handleItemEntityMovement(world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && BetterDivingConfig.getInstance().general.itemEntityMovement && event.phase == TickEvent.Phase.END) {
            EntityEventHandler.handleItemEntityMovement((World)world);
        }
    }

    public static void handleItemEntityMovement(World world) {
        if (world != null) {
            for (Entity entity : world.field_72996_f) {
                if (!(entity instanceof EntityItem) || !entity.func_70090_H() || entity.field_70122_E || entity.func_189652_ae()) continue;
                entity.field_70181_x += (double)0.04f * (1.0 - BetterDivingConfig.getInstance().general.itemEntityMovementFactor);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityItem) {
            Entity entity = event.getEntity();
            if (event.getWorld().func_180495_p(new BlockPos(entity)).func_185904_a() == Material.field_151586_h) {
                double d = 1.0 - 0.5 * (1.0 - BetterDivingConfig.getInstance().general.itemEntityMovementFactor);
                entity.field_70159_w *= d;
                entity.field_70181_x *= d;
                entity.field_70179_y *= d;
            }
        }
    }
}

