/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.item;

import java.util.List;
import javax.annotation.Nullable;
import meldexun.better_diving.client.ArmorModels;
import meldexun.better_diving.util.config.DivingGearConfig;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractItemDivingGear
extends ItemArmor {
    protected final DivingGearConfig config;

    public AbstractItemDivingGear(ItemArmor.ArmorMaterial material, EntityEquipmentSlot slot, DivingGearConfig config) {
        super(material, 0, slot);
        this.config = config;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (armorSlot == EntityEquipmentSlot.LEGS) {
            return ArmorModels.divingGearModelLegs;
        }
        if (entityLiving instanceof AbstractClientPlayer && ((AbstractClientPlayer)entityLiving).func_175154_l().equals("slim")) {
            return ArmorModels.divingGearModelSlim;
        }
        return ArmorModels.divingGearModel;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (Loader.isModLoaded((String)"mobends") && slot != EntityEquipmentSlot.LEGS) {
            return "better_diving:textures/models/armor/" + this.func_82812_d().func_179242_c().substring(14) + "_layer_1_old.png";
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.isReinforced()) {
            tooltip.add(I18n.func_135052_a((String)"item.reinforced_gear.tooltip", (Object[])new Object[0]));
        }
    }

    public DivingGearConfig getConfig() {
        return this.config;
    }

    public int getOxygenCapacity() {
        return 0;
    }

    public double getSwimSpeed() {
        return 0.0;
    }

    public float getBreakSpeed() {
        return 0.0f;
    }

    public boolean isImproved() {
        return this.config.improvedGear;
    }

    public boolean isReinforced() {
        return this.config.reinforcedGear;
    }
}

