/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.item;

import java.util.List;
import meldexun.better_diving.capability.item.oxygen.CapabilityOxygenProvider;
import meldexun.better_diving.capability.item.oxygen.ICapabilityOxygen;
import meldexun.better_diving.item.AbstractItemDivingGear;
import meldexun.better_diving.util.config.DivingGearConfig;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDivingChest
extends AbstractItemDivingGear {
    public ItemDivingChest(ItemArmor.ArmorMaterial material, DivingGearConfig config) {
        super(material, EntityEquipmentSlot.CHEST, config);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ICapabilityOxygen ioxygen = (ICapabilityOxygen)stack.getCapability(CapabilityOxygenProvider.OXYGEN, null);
        if (ioxygen.getOxygen() > 0) {
            int oxygen = (int)Math.round((double)ioxygen.getOxygen() / 20.0 / 3.0) * 3;
            tooltip.add(I18n.func_135052_a((String)"tooltip.oxygen", (Object[])new Object[]{oxygen}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.oxygen_empty", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"item.tank.tooltip", (Object[])new Object[]{(int)((double)this.getOxygenCapacity() / 20.0)}));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getOxygenCapacity() {
        return this.config.tankAirStorage;
    }

    @Override
    public double getSwimSpeed() {
        return this.config.tankMovespeed;
    }
}

