/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.item;

import java.util.List;
import meldexun.better_diving.capability.energy.IEnergyStorageExtended;
import meldexun.better_diving.item.ItemTooltip;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemEnergyStorage
extends ItemTooltip {
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public ItemEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this.func_77625_d(1);
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            ((IEnergyStorageExtended)stack.getCapability(CapabilityEnergy.ENERGY, null)).setEnergy(0);
            items.add((Object)stack);
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage s = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return 1.0 - (double)s.getEnergyStored() / (double)s.getMaxEnergyStored();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (flagIn.func_194127_a()) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.energy_advanced", (Object[])new Object[]{ItemEnergyStorage.getEnergyPercent(stack), ItemEnergyStorage.getEnergy(stack), this.capacity}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.energy", (Object[])new Object[]{ItemEnergyStorage.getEnergyPercent(stack)}));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static boolean hasEnergy(ItemStack stack) {
        return ItemEnergyStorage.getEnergy(stack) > 0;
    }

    public static int getEnergy(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemEnergyStorage) {
            IEnergyStorage ienergy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return ienergy.getEnergyStored();
        }
        return 0;
    }

    public static boolean setEnergy(ItemStack stack, int energy) {
        if (stack.func_77973_b() instanceof ItemEnergyStorage) {
            IEnergyStorage ienergy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            ((IEnergyStorageExtended)ienergy).setEnergy(energy);
            return true;
        }
        return false;
    }

    public static int getEnergyPercent(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemEnergyStorage) {
            IEnergyStorage ienergy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return ((IEnergyStorageExtended)ienergy).getEnergyPercent();
        }
        return 0;
    }

    public static int getEnergyCapacity(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemEnergyStorage) {
            IEnergyStorage ienergy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return ienergy.getMaxEnergyStored();
        }
        return 0;
    }

    public static int receiveEnergy(ItemStack stack, int amount) {
        if (stack.func_77973_b() instanceof ItemEnergyStorage && amount > 0) {
            IEnergyStorage ienergy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return ienergy.receiveEnergy(amount, false);
        }
        return 0;
    }

    public static int extractEnergy(ItemStack stack, int amount) {
        if (stack.func_77973_b() instanceof ItemEnergyStorage && amount > 0) {
            IEnergyStorage ienergy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return ienergy.extractEnergy(amount, false);
        }
        return 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }
}

