/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.item;

import java.util.List;
import meldexun.better_diving.init.ModItems;
import meldexun.better_diving.item.ItemBattery;
import meldexun.better_diving.item.ItemEnergyStorage;
import meldexun.better_diving.item.ItemTooltip;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemTool
extends ItemTooltip {
    public ItemTool() {
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            ((ItemStackHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).setStackInSlot(0, new ItemStack((Item)ModItems.BATTERY));
            items.add((Object)stack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemStack battery = ((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
        if (battery.func_77973_b() instanceof ItemBattery) {
            IEnergyStorage ienergy = (IEnergyStorage)battery.getCapability(CapabilityEnergy.ENERGY, null);
            int percent = (int)(100.0 * (double)ienergy.getEnergyStored() / (double)ienergy.getMaxEnergyStored());
            if (flagIn.func_194127_a()) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.energy_advanced", (Object[])new Object[]{percent, ienergy.getEnergyStored(), ienergy.getMaxEnergyStored()}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"tooltip.energy", (Object[])new Object[]{percent}));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.no_battery", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static boolean hasEnergy(ItemStack stack) {
        ItemStack battery = ((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
        if (battery.func_77973_b() instanceof ItemBattery) {
            return ItemEnergyStorage.hasEnergy(battery);
        }
        return false;
    }

    public static int getEnergy(ItemStack stack) {
        ItemStack battery = ((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
        if (battery.func_77973_b() instanceof ItemBattery) {
            return ItemEnergyStorage.getEnergy(battery);
        }
        return 0;
    }

    public static boolean setEnergy(ItemStack stack, int energy) {
        ItemStack battery = ((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
        if (battery.func_77973_b() instanceof ItemEnergyStorage) {
            return ItemEnergyStorage.setEnergy(battery, energy);
        }
        return false;
    }

    public static int getEnergyPercent(ItemStack stack) {
        ItemStack battery = ((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
        if (battery.func_77973_b() instanceof ItemEnergyStorage) {
            return ItemEnergyStorage.getEnergyPercent(stack);
        }
        return 0;
    }

    public static int getEnergyCapacity(ItemStack stack) {
        ItemStack battery = ((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
        if (battery.func_77973_b() instanceof ItemBattery) {
            return ItemEnergyStorage.getEnergyCapacity(battery);
        }
        return 0;
    }

    public static int receiveEnergy(ItemStack stack, int amount) {
        ItemStack battery;
        if (amount > 0 && (battery = ((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0)).func_77973_b() instanceof ItemBattery) {
            return ItemEnergyStorage.receiveEnergy(battery, amount);
        }
        return 0;
    }

    public static int extractEnergy(ItemStack stack, int amount) {
        ItemStack battery;
        if (amount > 0 && (battery = ((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0)).func_77973_b() instanceof ItemBattery) {
            return ItemEnergyStorage.extractEnergy(battery, amount);
        }
        return 0;
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        IItemHandler iitemhandler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ((ItemStackHandler)iitemhandler).setStackInSlot(0, new ItemStack((Item)ModItems.BATTERY));
    }
}

