/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.item.crafting;

import meldexun.better_diving.util.CraftingHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

public class Recipe
extends IForgeRegistryEntry.Impl<Recipe> {
    public static final IForgeRegistry<Recipe> REGISTRY = GameRegistry.findRegistry(Recipe.class);
    private ItemStack output;
    private ItemStack[] input;
    private boolean isRecipeValid;

    public Recipe(ItemStack output, ItemStack[] input) {
        this.output = output;
        this.input = input;
        this.fixInput();
        this.isRecipeValid = this.isOutputValid() && this.isInputValid();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getRegistryName() + "{" + this.output + ", [");
        if (this.input == null || this.input.length == 0) {
            s.append("null");
        } else {
            s.append(this.input[0]);
            for (int i = 1; i < this.input.length; ++i) {
                s.append(", " + this.input[i]);
            }
        }
        s.append("]}");
        return s.toString();
    }

    private void fixInput() {
        if (this.input != null && this.input.length >= 1) {
            block0: for (int i = 0; i < this.input.length; ++i) {
                ItemStack stack = this.input[i];
                if (stack == null || stack.func_190926_b()) {
                    this.input = (ItemStack[])ArrayUtils.remove((Object[])this.input, (int)i--);
                    continue;
                }
                for (int j = 0; j < i; ++j) {
                    ItemStack stack1 = this.input[j];
                    if (!CraftingHelper.areItemStacksEqualIgnoreCount(stack, stack1, false, false)) continue;
                    stack1.func_190920_e(stack1.func_190916_E() + stack.func_190916_E());
                    this.input = (ItemStack[])ArrayUtils.remove((Object[])this.input, (int)i--);
                    continue block0;
                }
            }
        }
    }

    public boolean canCraft(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return true;
        }
        NonNullList inventory = player.field_71071_by.field_70462_a;
        for (ItemStack stack : this.input) {
            if (CraftingHelper.remove((Iterable<ItemStack>)inventory, stack, true, false, false)) continue;
            return false;
        }
        return true;
    }

    public boolean tryCraft(EntityPlayer player) {
        ItemStack stack;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (!player.func_184812_l_()) {
            if (!this.canCraft(player)) {
                return false;
            }
            NonNullList inventory = player.field_71071_by.field_70462_a;
            for (ItemStack stack2 : this.input) {
                CraftingHelper.remove((Iterable<ItemStack>)inventory, stack2, false, false, false);
            }
        }
        if (!player.func_191521_c(stack = this.output.func_77946_l())) {
            player.func_70099_a(stack, 0.0f);
        }
        if (player.field_71070_bA != null) {
            player.field_71070_bA.func_75142_b();
        }
        return true;
    }

    private boolean isOutputValid() {
        return this.output != null && !this.output.func_190926_b();
    }

    private boolean isInputValid() {
        return this.input != null && this.input.length >= 1;
    }

    public boolean isRecipeValid() {
        return this.isRecipeValid;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public ItemStack[] getInput() {
        ItemStack[] array = new ItemStack[this.input.length];
        for (int i = 0; i < this.input.length; ++i) {
            array[i] = this.input[i].func_77946_l();
        }
        return array;
    }
}

