/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import meldexun.better_diving.BetterDiving;
import meldexun.better_diving.entity.AbstractEntityFish;
import meldexun.better_diving.registry.EntitySpawnEntry;
import meldexun.better_diving.util.BetterDivingConfig;
import meldexun.better_diving.util.EntityHelper;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="better_diving")
public class EntitySpawnRegistry {
    private static final Random RAND = new Random();

    @SubscribeEvent
    public static void createRegistry(RegistryEvent.NewRegistry event) {
        RegistryBuilder builder = new RegistryBuilder();
        builder.setType(EntitySpawnEntry.class);
        builder.setName(new ResourceLocation("better_diving", "entity_spawns"));
        builder.setIDRange(0, 32766);
        builder.create();
    }

    @SubscribeEvent
    public static void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K || event.phase == TickEvent.Phase.START || !BetterDivingConfig.getInstance().modules.entitySpawning || EntitySpawnEntry.REGISTRY.getValuesCollection().isEmpty() || !event.world.func_82736_K().func_82766_b("doMobSpawning")) {
            return;
        }
        WorldServer world = (WorldServer)event.world;
        Iterator iterator = world.getPersistentChunkIterable(world.func_184164_w().func_187300_b());
        while (iterator.hasNext()) {
            int z;
            int y;
            int x;
            BlockPos pos;
            Chunk chunk = (Chunk)iterator.next();
            if (!chunk.func_177410_o() || RAND.nextInt(BetterDivingConfig.getInstance().entities.chance) != 0 || world.func_180495_p(pos = new BlockPos(x = chunk.field_76635_g * 16 + RAND.nextInt(16), y = Math.max(world.func_181545_F() - 1, 1), z = chunk.field_76647_h * 16 + RAND.nextInt(16))).func_185904_a() != Material.field_151586_h) continue;
            int blocksToSeafloor = EntityHelper.blocksToSeafloor((World)world, pos);
            if (blocksToSeafloor > 10) {
                double modalValue = 0.75;
                double standardDeviation = 0.15;
                double min = 0.0;
                double max = 1.0;
                double d = MathHelper.func_151237_a((double)(modalValue + RAND.nextGaussian() * standardDeviation), (double)min, (double)max);
                pos = pos.func_177979_c((int)Math.round((double)blocksToSeafloor * d));
            } else if (blocksToSeafloor > 0) {
                pos = pos.func_177979_c(RAND.nextInt(blocksToSeafloor));
            }
            Vec3d vec = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            EntitySpawnEntry entitySpawnEntry = EntitySpawnRegistry.getRandomEntitySpawnEntryForPos((World)world, pos);
            if (entitySpawnEntry == null || !world.func_175636_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 64.0)) continue;
            int range = BetterDivingConfig.getInstance().entities.range;
            Vec3d vec1 = vec.func_178786_a((double)range, (double)range, (double)range);
            Vec3d vec2 = vec.func_72441_c((double)range, (double)range, (double)range);
            AxisAlignedBB aabb = new AxisAlignedBB(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
            if (EntitySpawnRegistry.getEntitiesWithinAABB(world, AbstractEntityFish.class, aabb, null).size() >= BetterDivingConfig.getInstance().entities.limit) continue;
            try {
                EntityLiving entity = entitySpawnEntry.createEntity((World)world);
                entity.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                world.func_72838_d((Entity)entity);
            }
            catch (Exception e) {
                BetterDiving.logger.error("Failed to spawn fish at " + pos, (Throwable)e);
            }
        }
    }

    protected static List<EntitySpawnEntry> getPossibleEntitySpawnEntryList(World world, BlockPos pos) {
        LinkedList<EntitySpawnEntry> possibleEntityEntryList = new LinkedList<EntitySpawnEntry>();
        for (EntitySpawnEntry entitySpawnEntry : EntitySpawnEntry.REGISTRY.getValuesCollection()) {
            if (!entitySpawnEntry.isEnabled() || !entitySpawnEntry.canSpawnAt(world, pos)) continue;
            possibleEntityEntryList.add(entitySpawnEntry);
        }
        return possibleEntityEntryList;
    }

    @Nullable
    protected static EntitySpawnEntry getRandomEntitySpawnEntryFromList(List<EntitySpawnEntry> entitySpawnEntryList) {
        if (entitySpawnEntryList.isEmpty()) {
            return null;
        }
        int i = 0;
        for (EntitySpawnEntry entry : entitySpawnEntryList) {
            i += entry.getWeight();
        }
        int j = RAND.nextInt(i);
        for (EntitySpawnEntry entry : entitySpawnEntryList) {
            if ((j -= entry.getWeight()) > 0) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    protected static EntitySpawnEntry getRandomEntitySpawnEntryForPos(World world, BlockPos pos) {
        return EntitySpawnRegistry.getRandomEntitySpawnEntryFromList(EntitySpawnRegistry.getPossibleEntitySpawnEntryList(world, pos));
    }

    protected static <T extends Entity> List<T> getEntitiesWithinAABB(WorldServer world, Class<? extends T> entityClass, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        int chunkX1 = (int)aabb.field_72340_a >> 4;
        int chunkZ1 = (int)aabb.field_72339_c >> 4;
        int chunkX2 = (int)aabb.field_72336_d >> 4;
        int chunkZ2 = (int)aabb.field_72334_f >> 4;
        ArrayList list = new ArrayList();
        for (int x = chunkX1; x <= chunkX2; ++x) {
            for (int z = chunkZ1; z <= chunkZ2; ++z) {
                if (!world.func_72863_F().func_73149_a(x, z)) continue;
                EntitySpawnRegistry.getEntitiesOfTypeWithinAABB(world.func_72964_e(x, z), entityClass, aabb, list, filter);
            }
        }
        return list;
    }

    protected static <T extends Entity> void getEntitiesOfTypeWithinAABB(Chunk chunk, Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, @Nullable Predicate<? super T> filter) {
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        int chunkY1 = MathHelper.func_76125_a((int)((int)aabb.field_72338_b >> 4), (int)0, (int)(entityLists.length - 1));
        int chunkY2 = MathHelper.func_76125_a((int)((int)aabb.field_72337_e >> 4), (int)0, (int)(entityLists.length - 1));
        for (int y = chunkY1; y <= chunkY2; ++y) {
            for (Entity entity : entityLists[y]) {
                if (!entityClass.isAssignableFrom(entity.getClass()) || !entity.func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.test(entity)) continue;
                listToFill.add(entity);
            }
        }
    }
}

