/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.registry;

import java.util.HashMap;
import java.util.Map;
import meldexun.better_diving.BetterDiving;
import meldexun.better_diving.structure.modules.SeabaseModule;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ModuleRegistry {
    private static final ModuleRegistry instance = new ModuleRegistry();
    private final Map<ResourceLocation, Class<? extends SeabaseModule>> modules = new HashMap<ResourceLocation, Class<? extends SeabaseModule>>();

    public static ModuleRegistry getInstance() {
        return instance;
    }

    public void register(ResourceLocation registryLocation, Class<? extends SeabaseModule> moduleClass) {
        if (registryLocation != null && !this.modules.containsKey(registryLocation)) {
            this.modules.put(registryLocation, moduleClass);
        }
    }

    public Map<ResourceLocation, Class<? extends SeabaseModule>> getRegistryMap() {
        return new HashMap<ResourceLocation, Class<? extends SeabaseModule>>(this.modules);
    }

    public Class<? extends SeabaseModule> getModuleClass(ResourceLocation moduleLocation) {
        return this.modules.get(moduleLocation);
    }

    public ResourceLocation getResourceLocation(Class<? extends SeabaseModule> moduleClass) {
        for (Map.Entry<ResourceLocation, Class<? extends SeabaseModule>> entry : this.modules.entrySet()) {
            if (!entry.getValue().equals(moduleClass)) continue;
            return entry.getKey();
        }
        return new ResourceLocation("better_diving", "");
    }

    public SeabaseModule createModuleFromResourceLocation(World world, ResourceLocation registryLocation) {
        Class<? extends SeabaseModule> moduleClass;
        if (world != null && registryLocation != null && (moduleClass = this.modules.get(registryLocation)) != null) {
            SeabaseModule module = null;
            try {
                module = moduleClass.getDeclaredConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                BetterDiving.logger.error("Failed to create seabase module from resource location " + registryLocation, (Throwable)e);
            }
            return module;
        }
        return null;
    }
}

