/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.structure;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import meldexun.better_diving.structure.manager.ModuleManager;
import meldexun.better_diving.structure.manager.StructureManager;
import meldexun.better_diving.structure.modules.SeabaseModule;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class SeabaseStructure {
    public final World world;
    private UUID uuid = MathHelper.func_188210_a();
    private Set<SeabaseModule> moduleList = new HashSet<SeabaseModule>();

    public SeabaseStructure(World world) {
        this.world = world;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Seabase Structure(uuid=" + this.uuid);
        for (SeabaseModule module : this.moduleList) {
            s.append(", " + (Object)((Object)module));
        }
        s.append(")");
        return s.toString();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean addSeabaseModule(SeabaseModule module) {
        if (!this.world.field_72995_K) {
            return this.moduleList.add(module);
        }
        return false;
    }

    public boolean removeSeabaseModule(SeabaseModule module) {
        if (!this.world.field_72995_K && this.moduleList.contains((Object)module)) {
            this.moduleList.remove((Object)module);
            this.split();
            return true;
        }
        return false;
    }

    public boolean exists() {
        return !this.moduleList.isEmpty();
    }

    public void delete() {
        this.moduleList.clear();
        StructureManager.getInstanceForWorld(this.world).removeStructure(this.uuid);
    }

    public static void merge(SeabaseStructure structure1, SeabaseStructure structure2) {
        if (structure1.moduleList.size() >= structure2.moduleList.size()) {
            structure1.merge(structure2);
        } else {
            structure2.merge(structure1);
        }
    }

    public void merge(SeabaseStructure structure) {
        if (structure != this && this.world == structure.world) {
            for (SeabaseModule module : structure.moduleList) {
                this.addSeabaseModule(module);
                module.setStructure(this);
            }
            structure.delete();
        }
    }

    public void split() {
        Set<SeabaseModule> modules;
        if (this.moduleList.isEmpty()) {
            this.delete();
        } else if (this.moduleList.size() > 1 && (modules = this.moduleList.iterator().next().getConnectedModules(new HashSet<SeabaseModule>())).size() < this.moduleList.size()) {
            SeabaseStructure structure = new SeabaseStructure(this.world);
            for (SeabaseModule module : modules) {
                this.moduleList.remove((Object)module);
                structure.addSeabaseModule(module);
                module.setStructure(structure);
            }
            StructureManager.getInstanceForWorld(this.world).addStructure(structure);
            this.split();
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("uuid", (NBTBase)NBTUtil.func_186862_a((UUID)this.uuid));
        NBTTagList nbtTagList = new NBTTagList();
        for (SeabaseModule module : this.moduleList) {
            nbtTagList.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)module.getUUID()));
        }
        compound.func_74782_a("moduleList", (NBTBase)nbtTagList);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.moduleList.clear();
        this.uuid = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("uuid"));
        NBTTagList nbtTagList = compound.func_150295_c("moduleList", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtTagList.func_150305_b(i);
            SeabaseModule module = ModuleManager.getInstanceForWorld(this.world).getModule(NBTUtil.func_186860_b((NBTTagCompound)tag));
            if (module == null) continue;
            module.setStructure(this);
            this.moduleList.add(module);
        }
    }
}

