/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.structure.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import meldexun.better_diving.BetterDiving;
import meldexun.better_diving.registry.ModuleRegistry;
import meldexun.better_diving.structure.modules.SeabaseModule;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;

public class ModuleManager {
    private static final Map<World, ModuleManager> instances = new HashMap<World, ModuleManager>();
    private final Map<UUID, SeabaseModule> modules = new HashMap<UUID, SeabaseModule>();
    private final World world;
    private final File folder;

    public ModuleManager(World world) {
        this.world = world;
        int dim = world.field_73011_w.getDimension();
        this.folder = dim == 0 ? new File(world.func_72860_G().func_75765_b(), "data/better_diving/modules") : new File(world.func_72860_G().func_75765_b(), "DIM" + dim + "/data/better_diving/modules");
    }

    public static void onWorldSave(World world) {
        if (!world.field_72995_K) {
            ModuleManager.getInstanceForWorld(world).saveData();
        }
    }

    public static void onWorldLoad(World world) {
        if (!world.field_72995_K) {
            ModuleManager.createInstanceForWorld(world);
            ModuleManager.getInstanceForWorld(world).loadData();
        }
    }

    public static void onWorldUnload(World world) {
        if (!world.field_72995_K) {
            ModuleManager.deleteInstanceForWorld(world);
        }
    }

    @Nullable
    public static ModuleManager getInstanceForWorld(World world) {
        if (world != null && !world.field_72995_K) {
            return instances.get(world);
        }
        return null;
    }

    private static boolean createInstanceForWorld(World world) {
        if (world != null && !world.field_72995_K && !instances.containsKey(world)) {
            instances.put(world, new ModuleManager(world));
            return true;
        }
        return false;
    }

    private static boolean deleteInstanceForWorld(World world) {
        if (world != null && !world.field_72995_K && instances.containsKey(world)) {
            instances.remove(world);
            return true;
        }
        return false;
    }

    public boolean addModule(SeabaseModule module) {
        if (module != null && !this.modules.containsKey(module.getUUID())) {
            this.modules.put(module.getUUID(), module);
            return true;
        }
        return false;
    }

    @Nullable
    public SeabaseModule getModule(UUID uuid) {
        if (uuid != null) {
            return this.modules.get(uuid);
        }
        return null;
    }

    public boolean hasModule(UUID uuid) {
        if (uuid != null) {
            return this.modules.containsKey(uuid);
        }
        return false;
    }

    public boolean removeModule(UUID uuid) {
        if (uuid != null && this.modules.containsKey(uuid)) {
            this.modules.remove(uuid);
            return true;
        }
        return false;
    }

    public void deleteInvalidModules() {
        LinkedList<SeabaseModule> list = new LinkedList<SeabaseModule>();
        for (SeabaseModule module : this.modules.values()) {
            if (module.exists()) continue;
            list.add(module);
        }
        for (SeabaseModule module : list) {
            module.delete();
        }
    }

    public void saveData() {
        if (!this.world.field_72995_K) {
            if (!this.folder.exists()) {
                this.folder.mkdirs();
            }
            for (File file : FileUtils.listFiles((File)this.folder, (String[])new String[]{"nbt"}, (boolean)false)) {
                file.delete();
            }
            this.deleteInvalidModules();
            for (SeabaseModule module : this.modules.values()) {
                this.createFileFromModule(this.folder, module);
            }
        }
    }

    public void createFileFromModule(File folder, SeabaseModule module) {
        File file = new File(folder, module.getUUID().toString() + ".nbt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)module.writeToNBT(), (OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            BetterDiving.logger.error("Failed to save seabase module to file: " + file.getName(), (Throwable)e);
        }
    }

    public void loadData() {
        if (!this.world.field_72995_K) {
            if (!this.folder.exists()) {
                this.folder.mkdirs();
            }
            for (File file : FileUtils.listFiles((File)this.folder, (String[])new String[]{"nbt"}, (boolean)false)) {
                this.createModuleFromFile(file);
            }
            for (SeabaseModule module : this.modules.values()) {
                module.updateDoors();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SeabaseModule createModuleFromFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            ResourceLocation registryName = new ResourceLocation(compound.func_74779_i("id"));
            SeabaseModule module = ModuleRegistry.getInstance().createModuleFromResourceLocation(this.world, registryName);
            if (module == null) return null;
            module.readFromNBT(compound);
            this.addModule(module);
            SeabaseModule seabaseModule = module;
            return seabaseModule;
        }
        catch (IOException e) {
            BetterDiving.logger.error("Failed to load seabase module from file: " + file.getName(), (Throwable)e);
        }
        return null;
    }
}

