/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.structure.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import meldexun.better_diving.BetterDiving;
import meldexun.better_diving.structure.SeabaseStructure;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;

public class StructureManager {
    private static final Map<World, StructureManager> instances = new HashMap<World, StructureManager>();
    private final Map<UUID, SeabaseStructure> structures = new HashMap<UUID, SeabaseStructure>();
    private final World world;
    private final File folder;

    public StructureManager(World world) {
        this.world = world;
        int dim = world.field_73011_w.getDimension();
        this.folder = dim == 0 ? new File(world.func_72860_G().func_75765_b(), "data/better_diving/structures") : new File(world.func_72860_G().func_75765_b(), "DIM" + dim + "/data/better_diving/structures");
    }

    public static void onWorldSave(World world) {
        if (!world.field_72995_K) {
            StructureManager.getInstanceForWorld(world).saveData();
        }
    }

    public static void onWorldLoad(World world) {
        if (!world.field_72995_K) {
            StructureManager.createInstanceForWorld(world);
            StructureManager.getInstanceForWorld(world).loadData();
        }
    }

    public static void onWorldUnload(World world) {
        if (!world.field_72995_K) {
            StructureManager.deleteInstanceForWorld(world);
        }
    }

    @Nullable
    public static StructureManager getInstanceForWorld(World world) {
        if (world != null && !world.field_72995_K) {
            return instances.get(world);
        }
        return null;
    }

    private static void createInstanceForWorld(World world) {
        if (world != null && !world.field_72995_K && !instances.containsKey(world)) {
            instances.put(world, new StructureManager(world));
        }
    }

    private static void deleteInstanceForWorld(World world) {
        if (world != null && !world.field_72995_K && instances.containsKey(world)) {
            instances.remove(world);
        }
    }

    public boolean addStructure(SeabaseStructure structure) {
        if (structure != null && !this.structures.containsKey(structure.getUUID())) {
            this.structures.put(structure.getUUID(), structure);
            return true;
        }
        return false;
    }

    public SeabaseStructure getStructure(UUID uuid) {
        if (uuid != null) {
            return this.structures.get(uuid);
        }
        return null;
    }

    public boolean hasStructure(UUID uuid) {
        if (uuid != null) {
            return this.structures.containsKey(uuid);
        }
        return false;
    }

    public boolean removeStructure(UUID uuid) {
        if (uuid != null && this.structures.containsKey(uuid)) {
            this.structures.remove(uuid);
            return true;
        }
        return false;
    }

    public void deleteInvalidModules() {
        LinkedList<SeabaseStructure> list = new LinkedList<SeabaseStructure>();
        for (SeabaseStructure structure : this.structures.values()) {
            if (structure.exists()) continue;
            list.add(structure);
        }
        for (SeabaseStructure structure : list) {
            structure.delete();
        }
    }

    public void saveData() {
        if (!this.world.field_72995_K) {
            if (!this.folder.exists()) {
                this.folder.mkdirs();
            }
            for (File file : FileUtils.listFiles((File)this.folder, (String[])new String[]{"nbt"}, (boolean)false)) {
                file.delete();
            }
            this.deleteInvalidModules();
            for (SeabaseStructure structure : this.structures.values()) {
                this.createFileFromStructure(this.folder, structure);
            }
        }
    }

    public void createFileFromStructure(File folder, SeabaseStructure structure) {
        File file = new File(folder, structure.getUUID().toString() + ".nbt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)structure.writeToNBT(), (OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            BetterDiving.logger.error("Failed to save seabase structure to file: " + file.getName(), (Throwable)e);
        }
    }

    public void loadData() {
        if (!this.world.field_72995_K) {
            if (!this.folder.exists()) {
                this.folder.mkdirs();
            }
            for (File file : FileUtils.listFiles((File)this.folder, (String[])new String[]{"nbt"}, (boolean)false)) {
                this.createStructureFromFile(file);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SeabaseStructure createStructureFromFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            SeabaseStructure structure = new SeabaseStructure(this.world);
            structure.readFromNBT(compound);
            this.addStructure(structure);
            SeabaseStructure seabaseStructure = structure;
            return seabaseStructure;
        }
        catch (IOException e) {
            BetterDiving.logger.error("Failed to load seabase structure from file: " + file.getName(), (Throwable)e);
            return null;
        }
    }
}

