/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.structure.modules;

import java.util.ArrayList;
import java.util.UUID;
import meldexun.better_diving.block.BlockStructure;
import meldexun.better_diving.structure.manager.ModuleManager;
import meldexun.better_diving.structure.modules.SeabaseModule;
import meldexun.better_diving.structure.modules.Wall;
import meldexun.better_diving.tileentity.TileEntityStructure;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Door
extends Wall {
    public SeabaseModule otherModule;
    private UUID otherModuleUUID;

    public Door(World world, SeabaseModule module) {
        super(world, module);
    }

    public Door(World world, SeabaseModule module, BlockStructure block, BlockPos startPos, BlockPos endPos, EnumFacing facing) {
        super(world, module, block, startPos, endPos, facing);
    }

    @Override
    public String toString() {
        return "Door(open=" + (this.otherModuleUUID != null) + ", x=" + this.startPos.func_177958_n() + ", y=" + this.startPos.func_177956_o() + ", z=" + this.startPos.func_177952_p() + ")";
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = super.writeToNBT();
        if (this.otherModule != null) {
            compound.func_74782_a("otherModule", (NBTBase)NBTUtil.func_186862_a((UUID)this.otherModule.getUUID()));
        }
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("otherModule")) {
            this.otherModuleUUID = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("otherModule"));
        }
    }

    public void updateOtherModule() {
        if (!this.world.field_72995_K && this.otherModuleUUID != null) {
            ModuleManager moduleManager = ModuleManager.getInstanceForWorld(this.world);
            this.otherModule = moduleManager.getModule(this.otherModuleUUID);
        }
    }

    @Override
    public void generate() {
        if (!this.world.field_72995_K) {
            if (this.check()) {
                BlockPos position = this.module.getBlockPos().func_177971_a((Vec3i)this.startPos).func_177972_a(this.facing);
                TileEntity tileEntity = this.world.func_175625_s(position);
                this.otherModule = ((TileEntityStructure)tileEntity).getModule();
                this.clear();
                Door otherDoor = this.otherModule.getDoorFromPos(position);
                if (otherDoor != null) {
                    otherDoor.clear();
                    otherDoor.otherModule = this.module;
                }
            } else {
                this.place();
            }
        }
    }

    public boolean check() {
        if (!this.world.field_72995_K) {
            ArrayList<SeabaseModule> list = new ArrayList<SeabaseModule>();
            BlockPos pos = this.module.getBlockPos().func_177971_a((Vec3i)this.startPos).func_177972_a(this.facing);
            for (int x = 0; x <= this.endPos.func_177958_n(); ++x) {
                for (int y = 0; y <= this.endPos.func_177956_o(); ++y) {
                    for (int z = 0; z <= this.endPos.func_177952_p(); ++z) {
                        TileEntity tileEntity = this.world.func_175625_s(pos.func_177982_a(x, y, z));
                        if (!(tileEntity instanceof TileEntityStructure) || !((TileEntityStructure)tileEntity).isDoor()) {
                            return false;
                        }
                        list.add(((TileEntityStructure)tileEntity).getModule());
                    }
                }
            }
            if (!list.isEmpty()) {
                SeabaseModule module1 = (SeabaseModule)((Object)list.get(0));
                for (SeabaseModule module2 : list) {
                    if (module1 == module2) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void delete() {
        if (!this.world.field_72995_K) {
            if (this.otherModule == null) {
                this.clear();
            } else {
                BlockPos position = this.module.getBlockPos().func_177971_a((Vec3i)this.startPos).func_177972_a(this.facing);
                Door otherDoor = this.otherModule.getDoorFromPos(position);
                if (otherDoor != null) {
                    otherDoor.place();
                    otherDoor.otherModule = null;
                }
            }
        }
    }

    @Override
    protected void place() {
        if (!this.world.field_72995_K) {
            BlockPos pos = this.module.getBlockPos().func_177971_a((Vec3i)this.startPos);
            for (int x = 0; x <= this.endPos.func_177958_n(); ++x) {
                for (int y = 0; y <= this.endPos.func_177956_o(); ++y) {
                    for (int z = 0; z <= this.endPos.func_177952_p(); ++z) {
                        this.block.placeBlock(this.world, pos.func_177982_a(x, y, z), 3, this.module, true);
                    }
                }
            }
        }
    }
}

