/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.structure.modules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import meldexun.better_diving.block.BlockStructure;
import meldexun.better_diving.structure.SeabaseStructure;
import meldexun.better_diving.structure.manager.ModuleManager;
import meldexun.better_diving.structure.manager.StructureManager;
import meldexun.better_diving.structure.modules.Door;
import meldexun.better_diving.structure.modules.Wall;
import meldexun.better_diving.tileentity.TileEntityStructure;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class SeabaseModule
extends IForgeRegistryEntry.Impl<SeabaseModule> {
    public final World world;
    private UUID uuid = MathHelper.func_188210_a();
    private int x;
    private int y;
    private int z;
    private Rotation rotation;
    private final List<Wall> wallList = new ArrayList<Wall>();
    private final List<Door> doorList = new ArrayList<Door>();
    private final Set<BlockPos> structurePartList = new HashSet<BlockPos>();
    private final Set<BlockPos> energyGeneratorList = new HashSet<BlockPos>();
    private SeabaseStructure structure;

    public SeabaseModule(World world) {
        this.world = world;
    }

    public SeabaseModule(World world, int x, int y, int z, Rotation rot) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.rotation = rot;
    }

    public String toString() {
        return "Seabase Module(uuid=" + this.uuid + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public void setStructure(SeabaseStructure structure) {
        this.structure = structure;
    }

    public SeabaseStructure getStructure() {
        return this.structure;
    }

    public void addWall(BlockStructure block, BlockPos start, BlockPos end, EnumFacing facing) {
        this.wallList.add(new Wall(this.world, this, block, start.func_190942_a(this.rotation), end.func_190942_a(this.rotation), this.getRotatedFacing(facing)));
    }

    public void addDoor(BlockStructure block, BlockPos start, BlockPos end, EnumFacing facing) {
        this.doorList.add(new Door(this.world, this, block, start.func_190942_a(this.rotation), end.func_190942_a(this.rotation), this.getRotatedFacing(facing)));
    }

    public void addStructurePart(BlockPos pos) {
        if (!this.world.field_72995_K && !this.structurePartList.contains(pos)) {
            this.structurePartList.add(pos);
            TileEntity tileEntity = this.world.func_175625_s(pos);
            if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, null)) {
                this.energyGeneratorList.add(pos);
            }
        }
    }

    public boolean removeStructurePart(BlockPos pos) {
        if (!this.world.field_72995_K && this.structurePartList.contains(pos)) {
            this.structurePartList.remove(pos);
            this.energyGeneratorList.remove(pos);
            return true;
        }
        return false;
    }

    public int getEnergyStored() {
        if (!this.world.field_72995_K) {
            int energy = 0;
            for (BlockPos pos : this.energyGeneratorList) {
                TileEntity tileEntity = this.world.func_175625_s(pos);
                if (tileEntity == null || !tileEntity.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
                energy += ((IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored();
            }
            return energy;
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        if (!this.world.field_72995_K) {
            int energy = 0;
            for (BlockPos pos : this.energyGeneratorList) {
                TileEntity tileEntity = this.world.func_175625_s(pos);
                if (tileEntity == null || !tileEntity.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
                energy += ((IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null)).getMaxEnergyStored();
            }
            return energy;
        }
        return 0;
    }

    public int extractEnergy(int amount, boolean simulate) {
        if (!this.world.field_72995_K) {
            amount = Math.abs(amount);
            int energyExtracted = 0;
            for (BlockPos pos : this.energyGeneratorList) {
                if (energyExtracted >= amount) break;
                TileEntity tileEntity = this.world.func_175625_s(pos);
                if (tileEntity == null || !tileEntity.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
                energyExtracted += ((IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(amount - energyExtracted, simulate);
            }
            return energyExtracted;
        }
        return 0;
    }

    public int receiveEnergy(int amount, boolean simulate) {
        if (!this.world.field_72995_K) {
            amount = Math.abs(amount);
            int energyReceived = 0;
            for (BlockPos pos : this.energyGeneratorList) {
                if (energyReceived >= amount) break;
                TileEntity tileEntity = this.world.func_175625_s(pos);
                if (tileEntity == null || !tileEntity.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
                energyReceived += ((IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(amount - energyReceived, simulate);
            }
            return energyReceived;
        }
        return 0;
    }

    private EnumFacing getRotatedFacing(EnumFacing facing) {
        if (facing.func_176740_k() != EnumFacing.Axis.Y) {
            if (this.rotation == Rotation.CLOCKWISE_90) {
                return facing.func_176746_e();
            }
            if (this.rotation == Rotation.CLOCKWISE_180) {
                return facing.func_176746_e().func_176746_e();
            }
            if (this.rotation == Rotation.COUNTERCLOCKWISE_90) {
                return facing.func_176735_f();
            }
        }
        return facing;
    }

    public Wall getWallFromPos(BlockPos pos) {
        for (Wall wall : this.wallList) {
            BlockPos start = this.getBlockPos().func_177971_a((Vec3i)wall.startPos);
            BlockPos end = start.func_177971_a((Vec3i)wall.endPos);
            if (pos.func_177958_n() < start.func_177958_n() || pos.func_177956_o() < start.func_177956_o() || pos.func_177952_p() < start.func_177952_p() || pos.func_177958_n() > end.func_177958_n() || pos.func_177956_o() > end.func_177956_o() || pos.func_177952_p() > end.func_177952_p()) continue;
            return wall;
        }
        return null;
    }

    public Door getDoorFromPos(BlockPos pos) {
        for (Door door : this.doorList) {
            BlockPos start = this.getBlockPos().func_177971_a((Vec3i)door.startPos);
            BlockPos end = start.func_177971_a((Vec3i)door.endPos);
            if (pos.func_177958_n() < start.func_177958_n() || pos.func_177956_o() < start.func_177956_o() || pos.func_177952_p() < start.func_177952_p() || pos.func_177958_n() > end.func_177958_n() || pos.func_177956_o() > end.func_177956_o() || pos.func_177952_p() > end.func_177952_p()) continue;
            return door;
        }
        return null;
    }

    public boolean exists() {
        for (Wall wall : this.wallList) {
            for (BlockPos pos : wall.getBlockPosList()) {
                TileEntity tileEntity = this.world.func_175625_s(pos);
                if (!(tileEntity instanceof TileEntityStructure) || ((TileEntityStructure)tileEntity).getModule() != this) continue;
                return true;
            }
        }
        return false;
    }

    public void delete() {
        if (this.structure != null) {
            this.structure.removeSeabaseModule(this);
        }
        ModuleManager.getInstanceForWorld(this.world).removeModule(this.uuid);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("id", this.getRegistryName().toString());
        compound.func_74782_a("uuid", (NBTBase)NBTUtil.func_186862_a((UUID)this.uuid));
        compound.func_74768_a("x", this.x);
        compound.func_74768_a("y", this.y);
        compound.func_74768_a("z", this.z);
        compound.func_74768_a("rot", this.rotation.ordinal());
        NBTTagList nbtTagList = new NBTTagList();
        for (Wall wall : this.wallList) {
            nbtTagList.func_74742_a((NBTBase)wall.writeToNBT());
        }
        compound.func_74782_a("wallList", (NBTBase)nbtTagList);
        NBTTagList nbtTagList1 = new NBTTagList();
        for (Door door : this.doorList) {
            nbtTagList1.func_74742_a((NBTBase)door.writeToNBT());
        }
        compound.func_74782_a("doorList", (NBTBase)nbtTagList1);
        NBTTagList nBTTagList = new NBTTagList();
        for (BlockPos pos : this.structurePartList) {
            nBTTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_74782_a("structurePartList", (NBTBase)nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (BlockPos pos : this.energyGeneratorList) {
            nBTTagList2.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_74782_a("energyGeneratorList", (NBTBase)nBTTagList2);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.wallList.clear();
        this.doorList.clear();
        this.structurePartList.clear();
        this.energyGeneratorList.clear();
        this.x = compound.func_74762_e("x");
        this.y = compound.func_74762_e("y");
        this.z = compound.func_74762_e("z");
        this.rotation = Rotation.values()[compound.func_74762_e("rot")];
        NBTTagList nbtTagList = compound.func_150295_c("wallList", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtTagList.func_150305_b(i);
            Wall wall = new Wall(this.world, this);
            wall.readFromNBT(tag);
            this.wallList.add(wall);
        }
        NBTTagList nbtTagList1 = compound.func_150295_c("doorList", 10);
        for (int i = 0; i < nbtTagList1.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtTagList1.func_150305_b(i);
            Door door = new Door(this.world, this);
            door.readFromNBT(tag);
            this.doorList.add(door);
        }
        NBTTagList nbtTagList2 = compound.func_150295_c("structurePartList", 10);
        for (int i = 0; i < nbtTagList2.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtTagList2.func_150305_b(i);
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)tag);
            this.structurePartList.add(pos);
        }
        NBTTagList nbtTagList3 = compound.func_150295_c("energyGeneratorList", 10);
        for (int i = 0; i < nbtTagList3.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtTagList3.func_150305_b(i);
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)tag);
            this.energyGeneratorList.add(pos);
        }
    }

    public void updateDoors() {
        if (!this.world.field_72995_K) {
            for (Door door : this.doorList) {
                door.updateOtherModule();
            }
        }
    }

    public boolean tryGenerate() {
        if (!this.world.field_72995_K) {
            ModuleManager moduleManager = ModuleManager.getInstanceForWorld(this.world);
            StructureManager structureManager = StructureManager.getInstanceForWorld(this.world);
            if (!moduleManager.hasModule(this.uuid) && this.canGenerate()) {
                SeabaseStructure seabaseStructure;
                this.structure = seabaseStructure = new SeabaseStructure(this.world);
                this.generate();
                moduleManager.addModule(this);
                seabaseStructure.addSeabaseModule(this);
                structureManager.addStructure(seabaseStructure);
                return true;
            }
        }
        return false;
    }

    public boolean canGenerate() {
        if (!this.world.field_72995_K) {
            for (Wall wall : this.wallList) {
                if (wall.canGenerate()) continue;
                return false;
            }
            for (Door door : this.doorList) {
                if (door.canGenerate()) continue;
                return false;
            }
            return this.canSetAirBlocks();
        }
        return false;
    }

    public void generate() {
        if (!this.world.field_72995_K) {
            this.setAirBlocks();
            for (Wall wall : this.wallList) {
                wall.generate();
            }
            for (Door door : this.doorList) {
                door.generate();
            }
        }
    }

    public abstract void setAirBlocks();

    public abstract boolean canSetAirBlocks();

    protected void setAirBlocks(BlockPos start, BlockPos end) {
        if (!this.world.field_72995_K) {
            start = start.func_190942_a(this.rotation);
            end = end.func_190942_a(this.rotation);
            BlockPos pos = this.getBlockPos().func_177971_a((Vec3i)start);
            for (int posX = 0; posX < end.func_177958_n(); ++posX) {
                for (int posY = 0; posY < end.func_177958_n(); ++posY) {
                    for (int posZ = 0; posZ < end.func_177958_n(); ++posZ) {
                        this.world.func_175698_g(pos.func_177982_a(posX, posY, posZ));
                    }
                }
            }
        }
    }

    public void destroy() {
        if (!this.world.field_72995_K) {
            for (Door door : this.doorList) {
                door.delete();
            }
            for (Wall wall : this.wallList) {
                wall.delete();
            }
            this.delete();
        }
    }

    public Set<SeabaseModule> getConnectedModules(Set<SeabaseModule> list) {
        list.add(this);
        if (!this.world.field_72995_K) {
            for (Wall wall : this.wallList) {
                for (BlockPos pos : wall.getBlockPosList()) {
                    this.getConnectedModules(pos, list);
                }
            }
        }
        return list;
    }

    private Set<SeabaseModule> getConnectedModules(BlockPos pos, Set<SeabaseModule> list) {
        if (!this.world.field_72995_K) {
            for (int i = 0; i < EnumFacing.values().length; ++i) {
                SeabaseModule otherModule;
                TileEntityStructure tileEntityStructure;
                TileEntity tileEntity = this.world.func_175625_s(pos.func_177972_a(EnumFacing.values()[i]));
                if (!(tileEntity instanceof TileEntityStructure) || (tileEntityStructure = (TileEntityStructure)tileEntity).isDoor() || (otherModule = tileEntityStructure.getModule()) == this || list.contains((Object)otherModule)) continue;
                otherModule.getConnectedModules(list);
            }
        }
        return list;
    }
}

