/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.structure.modules;

import java.util.ArrayList;
import java.util.List;
import meldexun.better_diving.block.BlockStructure;
import meldexun.better_diving.structure.modules.SeabaseModule;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Wall {
    public final World world;
    protected BlockPos startPos;
    protected BlockPos endPos;
    protected EnumFacing facing;
    protected SeabaseModule module;
    protected BlockStructure block;

    public Wall(World world, SeabaseModule module) {
        this.world = world;
        this.module = module;
    }

    public Wall(World world, SeabaseModule module, BlockStructure block, BlockPos startPos, BlockPos endPos, EnumFacing facing) {
        this.world = world;
        this.module = module;
        this.block = block;
        BlockPos minPos = new BlockPos(Math.min(startPos.func_177958_n(), endPos.func_177958_n()), Math.min(startPos.func_177956_o(), endPos.func_177956_o()), Math.min(startPos.func_177952_p(), endPos.func_177952_p()));
        BlockPos maxPos = new BlockPos(Math.max(startPos.func_177958_n(), endPos.func_177958_n()), Math.max(startPos.func_177956_o(), endPos.func_177956_o()), Math.max(startPos.func_177952_p(), endPos.func_177952_p()));
        this.startPos = minPos;
        this.endPos = maxPos.func_177973_b((Vec3i)minPos);
        this.facing = facing;
    }

    public String toString() {
        return "Wall(x=" + this.startPos.func_177958_n() + ", y=" + this.startPos.func_177956_o() + ", z=" + this.startPos.func_177952_p() + ")";
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("start", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.startPos));
        compound.func_74782_a("end", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.endPos));
        compound.func_74768_a("face", this.facing.func_176745_a());
        compound.func_74778_a("block", this.block.getRegistryName().toString());
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.startPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("start"));
        this.endPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("end"));
        this.facing = EnumFacing.func_82600_a((int)compound.func_74762_e("face"));
        this.block = (BlockStructure)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.func_74779_i("block")));
    }

    public List<BlockPos> getBlockPosList() {
        if (!this.world.field_72995_K) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            BlockPos pos = this.module.getBlockPos().func_177971_a((Vec3i)this.startPos);
            for (int x = 0; x <= this.endPos.func_177958_n(); ++x) {
                for (int y = 0; y <= this.endPos.func_177956_o(); ++y) {
                    for (int z = 0; z <= this.endPos.func_177952_p(); ++z) {
                        list.add(pos.func_177982_a(x, y, z));
                    }
                }
            }
            return list;
        }
        return new ArrayList<BlockPos>();
    }

    public boolean canGenerate() {
        if (!this.world.field_72995_K) {
            BlockPos pos = this.module.getBlockPos().func_177971_a((Vec3i)this.startPos);
            for (int x = 0; x <= this.endPos.func_177958_n(); ++x) {
                for (int y = 0; y <= this.endPos.func_177956_o(); ++y) {
                    for (int z = 0; z <= this.endPos.func_177952_p(); ++z) {
                        BlockPos position = pos.func_177982_a(x, y, z);
                        if (this.world.func_180495_p(position).func_177230_c().func_176200_f((IBlockAccess)this.world, position)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void generate() {
        if (!this.world.field_72995_K) {
            this.place();
        }
    }

    public void delete() {
        if (!this.world.field_72995_K) {
            this.clear();
        }
    }

    protected void place() {
        if (!this.world.field_72995_K) {
            BlockPos pos = this.module.getBlockPos().func_177971_a((Vec3i)this.startPos);
            for (int x = 0; x <= this.endPos.func_177958_n(); ++x) {
                for (int y = 0; y <= this.endPos.func_177956_o(); ++y) {
                    for (int z = 0; z <= this.endPos.func_177952_p(); ++z) {
                        this.block.placeBlock(this.world, pos.func_177982_a(x, y, z), 3, this.module, false);
                    }
                }
            }
        }
    }

    protected void clear() {
        if (!this.world.field_72995_K) {
            BlockPos pos = this.module.getBlockPos().func_177971_a((Vec3i)this.startPos);
            for (int x = 0; x <= this.endPos.func_177958_n(); ++x) {
                for (int y = 0; y <= this.endPos.func_177956_o(); ++y) {
                    for (int z = 0; z <= this.endPos.func_177952_p(); ++z) {
                        this.world.func_175698_g(pos.func_177982_a(x, y, z));
                    }
                }
            }
        }
    }
}

