/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.util;

import meldexun.better_diving.BetterDiving;
import meldexun.better_diving.network.packet.SPacketSyncConfig;
import meldexun.better_diving.util.ByteBufHelper;
import meldexun.better_diving.util.config.DivingGearConfig;
import meldexun.better_diving.util.config.EntityConfig;
import meldexun.better_diving.util.config.GeneratorConfig;
import meldexun.better_diving.util.config.GuiConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Config(modid="better_diving")
public class BetterDivingConfig {
    @Config.LangKey(value="config.better_diving")
    @Config.Comment(value={""})
    public static final BetterDivingConfig MASTER_CONFIG = new BetterDivingConfig();
    @Config.Ignore
    public static final BetterDivingConfig SLAVE_CONFIG = new BetterDivingConfig();
    @ByteBufHelper.Sync
    @Config.LangKey(value="config.category_general")
    @Config.Comment(value={""})
    public final General general = new General();
    @ByteBufHelper.Sync
    @Config.LangKey(value="config.category_modules")
    @Config.Comment(value={""})
    public final Modules modules = new Modules();
    @Config.LangKey(value="config.category_ores")
    @Config.Comment(value={""})
    public final Ores ores = new Ores();
    @Config.LangKey(value="config.category_plants")
    @Config.Comment(value={""})
    public final Plants plants = new Plants();
    @ByteBufHelper.Sync
    @Config.LangKey(value="config.category_diving_gear")
    @Config.Comment(value={""})
    public final DivingGear divingGear = new DivingGear();
    @ByteBufHelper.Sync
    @Config.LangKey(value="config.category_diving_values")
    @Config.Comment(value={""})
    public final DivingValues divingValues = new DivingValues();
    @Config.LangKey(value="config.category_client_settings")
    @Config.Comment(value={""})
    public final Client client = new Client();
    @Config.LangKey(value="config.category_entity_settings")
    @Config.Comment(value={""})
    public final Entities entities = new Entities();

    public static BetterDivingConfig getInstance() {
        return SLAVE_CONFIG;
    }

    @Mod.EventBusSubscriber(modid="better_diving")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("better_diving")) {
                ConfigManager.sync((String)"better_diving", (Config.Type)Config.Type.INSTANCE);
                Minecraft mc = Minecraft.func_71410_x();
                ByteBufHelper.copy(MASTER_CONFIG, SLAVE_CONFIG, mc.field_71441_e == null || mc.func_71356_B());
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.player.field_70170_p.field_72995_K) {
                EntityPlayer player = event.player;
                BetterDiving.network.sendTo((IMessage)new SPacketSyncConfig(), (EntityPlayerMP)player);
            }
        }
    }

    public static class Entities {
        @Config.LangKey(value="config.peeper")
        @Config.Comment(value={""})
        public EntityConfig peeper = new EntityConfig(true, 16, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.LangKey(value="config.bladderfish")
        @Config.Comment(value={""})
        public EntityConfig bladderfish = new EntityConfig(true, 12, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.LangKey(value="config.garryfish")
        @Config.Comment(value={""})
        public EntityConfig garryfish = new EntityConfig(true, 8, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.LangKey(value="config.holefish")
        @Config.Comment(value={""})
        public EntityConfig holefish = new EntityConfig(true, 8, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.LangKey(value="config.boomerang")
        @Config.Comment(value={""})
        public EntityConfig boomerang = new EntityConfig(true, 8, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.Comment(value={"For every chunk it chooses a random position every x ticks and then tries to spawn a random entity."})
        @Config.RangeInt(min=1, max=1000000)
        public int chance = 720;
        @Config.Comment(value={"Used to check how many fish are in range to determine whether to spawn more fish."})
        @Config.RangeInt(min=1, max=100)
        public int range = 16;
        @Config.Comment(value={"Only spawns more fish when there are less than x fish in range."})
        @Config.RangeInt(min=0, max=100)
        public int limit = 2;
    }

    public static class Client {
        @Config.LangKey(value="config.gui_oxygen")
        @Config.Comment(value={""})
        public GuiConfig guiOxygenConfig = new GuiConfig(true, 4, -114, -2);
        @Config.LangKey(value="config.gui_seamoth")
        @Config.Comment(value={""})
        public GuiConfig guiSeamothConfig = new GuiConfig(true, 3, -1, -1);
        @Config.LangKey(value="config.fog_settings")
        @Config.Comment(value={""})
        public Fog fogSettings = new Fog();
        @Config.Comment(value={"Currently unused. Enable/Disable the custom player model when diving."})
        public boolean customPlayerModel = true;
        @Config.Comment(value={"0: oxygen gui always enabled, 1: oxygen gui enabled while in water, 2: oxygen gui enabled while under water, 3: oxygen gui enabled while underwater or when oxygen is not full"})
        @Config.RangeInt(min=0, max=3)
        public int guiOxygen = 3;
        @Config.Comment(value={"Enable/Disable a more minecraft looking oxygen gui. It's recommended to set oxygen gui offsetX to 61 and offsetY to -34."})
        public boolean guiOxygenAlternative = false;
        @Config.Comment(value={"Hides the water overlay when wearing a diving gear helmet or when inside a vehicle."})
        public boolean hideWaterOverlay = true;
        @Config.Comment(value={"Enable/Disable underwater ambient sounds."})
        public boolean underWaterAmbience = true;

        public class Fog {
            @Config.Comment(value={"Enable/Disable fog color changes."})
            public boolean fogColorEnabled = false;
            @Config.Comment(value={"Enable/Disable fog density changes."})
            public boolean fogDensityEnabled = true;
            @Config.Comment(value={""})
            @Config.RangeDouble(min=1.0E-4, max=0.1)
            public double fogDensity = 0.016;
            @Config.Comment(value={"Fog density bonus in percent per block under water."})
            @Config.RangeDouble(min=-1.0, max=1.0)
            public double fogDensityBlocksUnderWater = 0.005;
            @Config.Comment(value={"Fog density bonus in percent during nighttime."})
            @Config.RangeDouble(min=-1.0, max=1.0)
            public double fogDensityNight = 1.0;
            @Config.Comment(value={""})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double[] fogColor = new double[]{0.1, 0.4, 0.9};
            @Config.Comment(value={"Fog color bonus in percent per block under water."})
            @Config.RangeDouble(min=-1.0, max=1.0)
            public double[] fogColorBlocksUnderWater = new double[]{-0.01, -0.01, -0.01};
            @Config.Comment(value={"Fog color bonus in percent during nighttime."})
            @Config.RangeDouble(min=-1.0, max=1.0)
            public double[] fogColorNight = new double[]{-0.9, -0.9, -0.9};
        }
    }

    public static class DivingValues {
        @ByteBufHelper.Sync
        @Config.Comment(value={"Oxygen capacity in ticks (20 ticks = 1 second)"})
        @Config.RangeInt(min=0, max=10000)
        public int airBase = 900;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Enable/Disable decreased oxygen efficiency while diving deeper"})
        public boolean airEfficiency = true;
        @ByteBufHelper.Sync
        @Config.Comment(value={"When 'airEfficiency' is enabled, diving every x blocks deep consumes one unit of oxygen more per second."})
        @Config.RangeInt(min=1, max=256)
        public int airEfficiencyLimit = 32;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Oxygen capacity in ticks (20 ticks = 1 second)"})
        @Config.RangeInt(min=0, max=10000)
        public int airPerRespirationLevel = 300;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Break speed underwater based on normal break speed"})
        @Config.RangeDouble(min=0.0, max=2.0)
        public double breakSpeed = 1.0;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Break speed bonus underwater with the Aqua Affinity Enchantment"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double breakSpeedAquaAffinity = 0.15;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Amount of energy the seaglide uses per tick (20 ticks = 1 second)"})
        @Config.RangeInt(min=0, max=1000)
        public int seaglideEnergyUsage = 65;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Seaglide swim speed. (blocks per second = x * 100)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double seaglideSpeed = 0.11;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Amount of energy the seamoth uses per tick (20 ticks = 1 second)"})
        @Config.RangeInt(min=0, max=1000)
        public int seamothEnergyUsage = 130;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Speed of the seamoth. (blocks per second = x * 100 * 20 / 5)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double seamothSpeed = 0.0275;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Basic swim speed. (min = x / 3; max = x * 4 / 3; vanilla ~ 0.0196D) (blocks per second = x * 100)"})
        @Config.RangeDouble(min=0.0, max=0.1)
        public double swimSpeed = 0.042;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Depth strider bonus swim speed in percent"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double swimSpeedDepthStrider = 0.1;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Lower swim speed limit in percent."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double swimSpeedLimitLower = 0.3333;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Upper swim speed limit in percent."})
        @Config.RangeDouble(min=1.0, max=2.0)
        public double swimSpeedLimitUpper = 1.3333;
    }

    public static class DivingGear {
        @ByteBufHelper.Sync
        @Config.LangKey(value="config.diving_gear")
        @Config.Comment(value={""})
        public DivingGearConfig basicDivingGear = new DivingGearConfig(0.1667, false, false, 0.15, 600, -0.08, 60, 10, new int[]{1, 3, 5, 1}, 0.0f);
        @ByteBufHelper.Sync
        @Config.LangKey(value="config.improved_diving_gear")
        @Config.Comment(value={""})
        public DivingGearConfig improvedDivingGear = new DivingGearConfig(0.3333, true, false, 0.3, 1800, -0.08, 60, 10, new int[]{1, 3, 5, 1}, 0.0f);
        @ByteBufHelper.Sync
        @Config.LangKey(value="config.reinforced_diving_gear")
        @Config.Comment(value={""})
        public DivingGearConfig reinforcedDivingGear = new DivingGearConfig(0.1667, false, true, 0.15, 600, -0.08, 80, 10, new int[]{2, 5, 7, 2}, 0.5f);
    }

    public static class Plants {
        @Config.LangKey(value="config.acid_mushroom")
        @Config.Comment(value={""})
        public GeneratorConfig acidMushroom = new GeneratorConfig(true, 12, 8, 4, 60, true, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.LangKey(value="config.creepvine")
        @Config.Comment(value={""})
        public GeneratorConfig creepvine = new GeneratorConfig(true, 16, 16, 16, 60, true, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.LangKey(value="config.seagrass")
        @Config.Comment(value={""})
        public GeneratorConfig seagrass = new GeneratorConfig(true, 1, 24, 4, 60, true, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.LangKey(value="config.seagrass_tall")
        @Config.Comment(value={""})
        public GeneratorConfig seagrassTall = new GeneratorConfig(true, 4, 12, 4, 60, true, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.Comment(value={""})
        public boolean shouldGenerateCreepvineSeedCluster = true;
    }

    public static class Ores {
        @Config.LangKey(value="config.limestone")
        @Config.Comment(value={""})
        public GeneratorConfig limestone = new GeneratorConfig(true, 2, 1, 4, 60, true, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.LangKey(value="config.sandstone")
        @Config.Comment(value={""})
        public GeneratorConfig sandstone = new GeneratorConfig(true, 4, 1, 24, 60, true, false, new String[]{"OCEAN"}, new String[]{"ocean", "deep_ocean"}, new int[]{0});
        @Config.LangKey(value="config.sand_layer")
        @Config.Comment(value={""})
        public SandLayer sandLayer = new SandLayer();

        public class SandLayer {
            @Config.Comment(value={"Enable/Disable sand layer generation."})
            public boolean shouldGenerate = true;
            @Config.Comment(value={"Usage changes depending on seaLevelRelative."})
            @Config.RangeInt(min=0, max=256)
            public int minHeight = 4;
            @Config.Comment(value={"Usage changes depending on seaLevelRelative."})
            @Config.RangeInt(min=0, max=256)
            public int maxHeight = 20;
            @Config.Comment(value={"When enabled minHeight defines how many blocks below sea level you have to at least be to find this plant/ore and maxHeight defines how many blocks below sea level you have to at most be to find this plant/ore."})
            public boolean seaLevelRelative = true;
            @Config.Comment(value={"Set this to true to generate this plant/ore in every biome."})
            @Config.Ignore
            public boolean biomeOverride = false;
            @Config.Comment(value={"Biome types in which this plant/ore can generate."})
            public String[] biomeTypes = new String[]{"OCEAN"};
            @Config.Comment(value={"Biomes in which this plant/ore should generate. For modded biomes: modid:biome_name."})
            public String[] biomes = new String[]{"ocean", "deep_ocean"};
            @Config.Comment(value={"Dimensions in which this plant/ore should generate."})
            public int[] dimensions = new int[]{0};

            public boolean isEnabled() {
                if (this.dimensions.length == 0) {
                    return false;
                }
                if (!this.biomeOverride && this.biomeTypes.length == 0 && this.biomes.length == 0) {
                    return false;
                }
                return this.shouldGenerate;
            }

            public ResourceLocation[] getBiomes() {
                ResourceLocation[] biomeRegistryNames = new ResourceLocation[this.biomes.length];
                for (int i = 0; i < this.biomes.length; ++i) {
                    biomeRegistryNames[i] = new ResourceLocation(this.biomes[i]);
                }
                return biomeRegistryNames;
            }
        }
    }

    public static class Modules {
        @ByteBufHelper.Sync
        @Config.Comment(value={""})
        public boolean blockBreaking = true;
        @ByteBufHelper.Sync
        @Config.Comment(value={""})
        public boolean divingMovement = true;
        @Config.Comment(value={""})
        public boolean entitySpawning = true;
        @Config.Comment(value={""})
        public boolean oreGeneration = true;
        @ByteBufHelper.Sync
        @Config.Comment(value={""})
        public boolean oxygenHandling = true;
        @Config.Comment(value={""})
        public boolean plantGeneration = true;
        @Config.Comment(value={""})
        public boolean visionUnderWater = true;
    }

    public static class General {
        @ByteBufHelper.Sync
        @Config.Comment(value={"Enable/Disable changes to item entity sinking in water."})
        public boolean itemEntityMovement = true;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Factor in percent how fast item entities sink in water."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double itemEntityMovementFactor = 0.125;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Enable/Disable packets to sync oxygen. Should prevent desync of client and server. But increases network traffic and comes with a latency. Not recommended unless you have experienced desync."})
        public boolean oxygenSyncPackets = false;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Enable/Disable packets to sync seaglide energy. Should prevent desync of client and server. But increases network traffic and comes with a latency. Not recommended unless you have experienced desync."})
        public boolean seaglideEnergySyncPackets = false;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Enable/Disable packets to sync seamoth energy. Should prevent desync of client and server. But increases network traffic and comes with a latency. Not recommended unless you have experienced desync."})
        public boolean seamothEnergySyncPackets = false;
        @ByteBufHelper.Sync
        @Config.Comment(value={"When 'divingMovement' module is enabled the movemet will be altered to be similar to MC 1.13."})
        public boolean vanillaDivingMovement = false;
        @ByteBufHelper.Sync
        @Config.Comment(value={"Enable/Disable resizing of the player when sprint diving or in a seamoth."})
        public boolean playerResizing = true;
        @ByteBufHelper.Sync
        @Config.Comment(value={"When 'playerResizing' is enabled and ArtemisLib is loaded the player will be resized using ArtemisLib. Might cause visual and/or eye height glitches."})
        public boolean artemisLibCompatibility = true;
    }
}

