/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.util;

import io.netty.buffer.ByteBuf;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import meldexun.better_diving.BetterDiving;

public class ByteBufHelper {
    private ByteBufHelper() {
    }

    public static void fromBytes(Object object, ByteBuf buf) {
        Class<?> objectClass = object.getClass();
        Field[] fields = objectClass.getFields();
        int booleanFields = buf.readByte();
        int byteFields = buf.readByte();
        int shortFields = buf.readByte();
        int integerFields = buf.readByte();
        int longFields = buf.readByte();
        int floatFields = buf.readByte();
        int doubleFields = buf.readByte();
        int objectFields = buf.readByte();
        try {
            byte fieldNumber;
            int i;
            for (i = 0; i < booleanFields; ++i) {
                fieldNumber = buf.readByte();
                fields[fieldNumber].set(object, buf.readBoolean());
            }
            for (i = 0; i < byteFields; ++i) {
                fieldNumber = buf.readByte();
                fields[fieldNumber].set(object, buf.readByte());
            }
            for (i = 0; i < shortFields; ++i) {
                fieldNumber = buf.readByte();
                fields[fieldNumber].set(object, buf.readShort());
            }
            for (i = 0; i < integerFields; ++i) {
                fieldNumber = buf.readByte();
                fields[fieldNumber].set(object, buf.readInt());
            }
            for (i = 0; i < longFields; ++i) {
                fieldNumber = buf.readByte();
                fields[fieldNumber].set(object, buf.readLong());
            }
            for (i = 0; i < floatFields; ++i) {
                fieldNumber = buf.readByte();
                fields[fieldNumber].set(object, Float.valueOf(buf.readFloat()));
            }
            for (i = 0; i < doubleFields; ++i) {
                fieldNumber = buf.readByte();
                fields[fieldNumber].set(object, buf.readDouble());
            }
            for (i = 0; i < objectFields; ++i) {
                fieldNumber = buf.readByte();
                ByteBufHelper.fromBytes(fields[fieldNumber].get(object), buf);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            BetterDiving.logger.error("Failed to read bytes for " + objectClass, (Throwable)e);
        }
    }

    public static void toBytes(Object object, ByteBuf buf) {
        Class<?> objectClass = object.getClass();
        Field[] fields = objectClass.getFields();
        HashMap<Byte, Field> booleanFields = new HashMap<Byte, Field>();
        HashMap<Byte, Field> byteFields = new HashMap<Byte, Field>();
        HashMap<Byte, Field> shortFields = new HashMap<Byte, Field>();
        HashMap<Byte, Field> integerFields = new HashMap<Byte, Field>();
        HashMap<Byte, Field> longFields = new HashMap<Byte, Field>();
        HashMap<Byte, Field> floatFields = new HashMap<Byte, Field>();
        HashMap<Byte, Field> doubleFields = new HashMap<Byte, Field>();
        HashMap<Byte, Field> objectFields = new HashMap<Byte, Field>();
        for (int i = 0; i < fields.length && i < 128; ++i) {
            Field field = fields[i];
            if (!field.isAnnotationPresent(Sync.class)) continue;
            Class<?> fieldClass = field.getType();
            if (fieldClass.equals(Boolean.TYPE)) {
                booleanFields.put((byte)i, field);
                continue;
            }
            if (fieldClass.equals(Byte.TYPE)) {
                byteFields.put((byte)i, field);
                continue;
            }
            if (fieldClass.equals(Short.TYPE)) {
                shortFields.put((byte)i, field);
                continue;
            }
            if (fieldClass.equals(Integer.TYPE)) {
                integerFields.put((byte)i, field);
                continue;
            }
            if (fieldClass.equals(Long.TYPE)) {
                longFields.put((byte)i, field);
                continue;
            }
            if (fieldClass.equals(Float.TYPE)) {
                floatFields.put((byte)i, field);
                continue;
            }
            if (fieldClass.equals(Double.TYPE)) {
                doubleFields.put((byte)i, field);
                continue;
            }
            if (!fieldClass.getSuperclass().equals(Object.class) || fieldClass.equals(objectClass)) continue;
            objectFields.put((byte)i, field);
        }
        buf.writeByte(booleanFields.size());
        buf.writeByte(byteFields.size());
        buf.writeByte(shortFields.size());
        buf.writeByte(integerFields.size());
        buf.writeByte(longFields.size());
        buf.writeByte(floatFields.size());
        buf.writeByte(doubleFields.size());
        buf.writeByte(objectFields.size());
        try {
            for (Map.Entry entry : booleanFields.entrySet()) {
                buf.writeByte((int)((Byte)entry.getKey()).byteValue());
                buf.writeBoolean(((Field)entry.getValue()).getBoolean(object));
            }
            for (Map.Entry entry : byteFields.entrySet()) {
                buf.writeByte((int)((Byte)entry.getKey()).byteValue());
                buf.writeByte((int)((Field)entry.getValue()).getByte(object));
            }
            for (Map.Entry entry : shortFields.entrySet()) {
                buf.writeByte((int)((Byte)entry.getKey()).byteValue());
                buf.writeShort((int)((Field)entry.getValue()).getShort(object));
            }
            for (Map.Entry entry : integerFields.entrySet()) {
                buf.writeByte((int)((Byte)entry.getKey()).byteValue());
                buf.writeInt(((Field)entry.getValue()).getInt(object));
            }
            for (Map.Entry entry : longFields.entrySet()) {
                buf.writeByte((int)((Byte)entry.getKey()).byteValue());
                buf.writeLong(((Field)entry.getValue()).getLong(object));
            }
            for (Map.Entry entry : floatFields.entrySet()) {
                buf.writeByte((int)((Byte)entry.getKey()).byteValue());
                buf.writeFloat(((Field)entry.getValue()).getFloat(object));
            }
            for (Map.Entry entry : doubleFields.entrySet()) {
                buf.writeByte((int)((Byte)entry.getKey()).byteValue());
                buf.writeDouble(((Field)entry.getValue()).getDouble(object));
            }
            for (Map.Entry entry : objectFields.entrySet()) {
                buf.writeByte((int)((Byte)entry.getKey()).byteValue());
                ByteBufHelper.toBytes(((Field)entry.getValue()).get(object), buf);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            BetterDiving.logger.error("Failed to write bytes for " + objectClass, (Throwable)e);
        }
    }

    public static void copy(Object source, Object target, boolean copyServerSettings) {
        Field[] fields;
        if (source == null || target == null || source.getClass() != target.getClass()) {
            return;
        }
        for (Field field : fields = source.getClass().getFields()) {
            if (!copyServerSettings && field.isAnnotationPresent(Sync.class)) continue;
            Class<?> fieldClass = field.getType();
            try {
                if (fieldClass.isPrimitive() || fieldClass.equals(String.class)) {
                    field.set(target, field.get(source));
                    continue;
                }
                if (fieldClass.isArray() && (fieldClass.getComponentType().isPrimitive() || fieldClass.getComponentType().equals(String.class))) {
                    Object array1 = field.get(source);
                    int length = Array.getLength(array1);
                    Object array2 = Array.newInstance(fieldClass.getComponentType(), length);
                    System.arraycopy(array1, 0, array2, 0, length);
                    field.set(target, array2);
                    continue;
                }
                if (!fieldClass.getSuperclass().equals(Object.class)) continue;
                Object source2 = field.get(source);
                Object target2 = field.get(target);
                if (source2 == source || target2 == target) continue;
                ByteBufHelper.copy(field.get(source), field.get(target), copyServerSettings);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                BetterDiving.logger.error("Failed to copy data from " + source + " to " + target, (Throwable)e);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Sync {
    }
}

