/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.util.config;

import meldexun.better_diving.util.ByteBufHelper;
import meldexun.better_diving.util.config.ArmorConfig;
import net.minecraftforge.common.config.Config;

public class DivingGearConfig {
    public ArmorConfig armorValues;
    @ByteBufHelper.Sync
    @Config.Comment(value={"Swim speed bonus in percent"})
    @Config.RangeDouble(min=0.0, max=1.0)
    public double finsMovespeed;
    @ByteBufHelper.Sync
    @Config.Comment(value={"An improved diving mask removes the oxygen usage penality when diving deep"})
    public boolean improvedGear;
    @ByteBufHelper.Sync
    @Config.Comment(value={"Reinforced diving dear shows tool tip"})
    public boolean reinforcedGear;
    @ByteBufHelper.Sync
    @Config.Comment(value={"Break speed bonus in percent"})
    @Config.RangeDouble(min=0.0, max=1.0)
    public double legsBreakspeed;
    @ByteBufHelper.Sync
    @Config.Comment(value={"Oxygen capacity in ticks (20 ticks = 1 second)"})
    @Config.RangeInt(min=0, max=10000)
    public int tankAirStorage;
    @ByteBufHelper.Sync
    @Config.Comment(value={"Swim speed bonus in percent"})
    @Config.RangeDouble(min=-1.0, max=0.0)
    public double tankMovespeed;

    public DivingGearConfig(double finsMovespeed, boolean improvedGear, boolean reinforcedGear, double legsBreakspeed, int tankAirStorage, double tankMovespeed, ArmorConfig armorValues) {
        this.finsMovespeed = finsMovespeed;
        this.improvedGear = improvedGear;
        this.legsBreakspeed = legsBreakspeed;
        this.reinforcedGear = reinforcedGear;
        this.tankAirStorage = tankAirStorage;
        this.tankMovespeed = tankMovespeed;
        this.armorValues = armorValues;
    }

    public DivingGearConfig(double finsMovespeed, boolean improvedGear, boolean reinforcedGear, double legsBreakspeed, int tankAirStorage, double tankMovespeed, int durability, int enchantability, int[] protection, float toughness) {
        this.finsMovespeed = finsMovespeed;
        this.improvedGear = improvedGear;
        this.legsBreakspeed = legsBreakspeed;
        this.reinforcedGear = reinforcedGear;
        this.tankAirStorage = tankAirStorage;
        this.tankMovespeed = tankMovespeed;
        this.armorValues = new ArmorConfig(durability, enchantability, protection, toughness);
    }
}

