/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import meldexun.better_diving.init.ModBlocks;
import meldexun.better_diving.util.BetterDivingConfig;
import meldexun.better_diving.world.generator.WorldGeneratorCreepvine;
import meldexun.better_diving.world.generator.WorldGeneratorOcean;
import meldexun.better_diving.world.generator.WorldGeneratorSandLayer;
import meldexun.better_diving.world.generator.WorldGeneratorSeagrassTall;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOcean
implements IWorldGenerator {
    private static WorldGeneratorSandLayer sandLayerGenerator;
    private static List<WorldGeneratorOcean> oreGenerators;
    private static List<WorldGeneratorOcean> plantGenerators;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        sandLayerGenerator.generate(world, random, chunkX, chunkZ);
        if (BetterDivingConfig.getInstance().modules.oreGeneration) {
            for (WorldGeneratorOcean generator : oreGenerators) {
                generator.generate(world, random, chunkX, chunkZ);
            }
        }
        if (BetterDivingConfig.getInstance().modules.plantGeneration) {
            for (WorldGeneratorOcean generator : plantGenerators) {
                generator.generate(world, random, chunkX, chunkZ);
            }
        }
    }

    static {
        oreGenerators = new ArrayList<WorldGeneratorOcean>();
        plantGenerators = new ArrayList<WorldGeneratorOcean>();
        sandLayerGenerator = new WorldGeneratorSandLayer(Blocks.field_150354_m.func_176223_P(), BetterDivingConfig.getInstance().ores.sandLayer);
        oreGenerators.add(new WorldGeneratorOcean(ModBlocks.LIMESTONE_OUTCROP.func_176223_P(), BetterDivingConfig.getInstance().ores.limestone));
        oreGenerators.add(new WorldGeneratorOcean(ModBlocks.SANDSTONE_OUTCROP.func_176223_P(), BetterDivingConfig.getInstance().ores.sandstone));
        plantGenerators.add(new WorldGeneratorCreepvine());
        plantGenerators.add(new WorldGeneratorOcean(ModBlocks.ACID_MUSHROOM.func_176223_P(), BetterDivingConfig.getInstance().plants.acidMushroom));
        plantGenerators.add(new WorldGeneratorSeagrassTall());
        plantGenerators.add(new WorldGeneratorOcean(ModBlocks.SEAGRASS.func_176223_P(), BetterDivingConfig.getInstance().plants.seagrass));
    }
}

