/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.world.generator;

import java.util.Random;
import meldexun.better_diving.block.AbstractBlockCreepvine;
import meldexun.better_diving.init.ModBlocks;
import meldexun.better_diving.util.BetterDivingConfig;
import meldexun.better_diving.world.generator.WorldGeneratorOcean;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGeneratorCreepvine
extends WorldGeneratorOcean {
    public WorldGeneratorCreepvine() {
        super(ModBlocks.CREEPVINE.func_176223_P(), BetterDivingConfig.getInstance().plants.creepvine);
    }

    @Override
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (worldIn.func_180495_p(position.func_177977_b()).func_177230_c() instanceof AbstractBlockCreepvine) {
            return false;
        }
        if (ModBlocks.CREEPVINE.func_176196_c(worldIn, position)) {
            int i;
            int maxHeight = this.getMaxHeight(worldIn, rand, position);
            boolean generateSeeds = rand.nextInt(1000) < 250;
            for (i = 0; i < maxHeight - 1; ++i) {
                ModBlocks.CREEPVINE.setCreepvine(worldIn, position.func_177981_b(i), 18, maxHeight, generateSeeds);
            }
            ModBlocks.CREEPVINE_TOP.setCreepvine(worldIn, position.func_177981_b(i), 18, maxHeight, generateSeeds);
            if (BetterDivingConfig.getInstance().plants.shouldGenerateCreepvineSeedCluster && generateSeeds) {
                ModBlocks.CREEPVINE_SEED.setCreepvine(worldIn, position.func_177981_b((int)((double)maxHeight * 0.5)), 18, maxHeight, generateSeeds);
            }
            return true;
        }
        return false;
    }

    private int getMaxHeight(World worldIn, Random rand, BlockPos pos) {
        int i;
        int maxHeight = 14 - rand.nextInt(5);
        for (i = 1; i < maxHeight && this.checkTopAndSides(worldIn, pos.func_177981_b(i)); ++i) {
        }
        return i;
    }

    private boolean checkTopAndSides(World worldIn, BlockPos pos) {
        if (!ModBlocks.CREEPVINE.checkTop(worldIn, pos)) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (ModBlocks.CREEPVINE.isFullCubeOrWater(worldIn.func_180495_p(pos.func_177972_a(facing)))) continue;
            return false;
        }
        return true;
    }
}

