/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.world.generator;

import java.util.Random;
import java.util.Set;
import meldexun.better_diving.util.BlockHelper;
import meldexun.better_diving.util.config.GeneratorConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGeneratorOcean
extends WorldGenerator {
    protected final IBlockState blockToSpawn;
    protected final GeneratorConfig config;

    public WorldGeneratorOcean(IBlockState blockToSpawn, GeneratorConfig config) {
        this.blockToSpawn = blockToSpawn;
        this.config = config;
    }

    public void generate(World world, Random rand, int chunkX, int chunkZ) {
        if (this.config.isEnabled() && this.canGenerateInDimension(world.field_73011_w.getDimension()) && rand.nextInt(this.config.chance) == 0) {
            for (int i = 0; i < this.config.amount; ++i) {
                int seaLevel = Math.max(world.func_181545_F() - 1, 1);
                BlockPos pos = new BlockPos(rand.nextInt(16) + chunkX * 16 + 8, seaLevel, rand.nextInt(16) + chunkZ * 16 + 8);
                Biome biome = world.func_72959_q().func_180631_a(pos);
                if (!this.canGenerateInBiome(biome) || !this.isHeightValid(seaLevel, (pos = BlockHelper.getSeaBed(world, pos)).func_177956_o())) continue;
                this.func_180709_b(world, rand, pos);
            }
        }
    }

    protected boolean isHeightValid(int seaLevel, int y) {
        if (this.config.seaLevelRelative) {
            return y <= seaLevel - this.config.minHeight && y >= seaLevel - this.config.maxHeight;
        }
        return y >= this.config.minHeight && y <= this.config.maxHeight;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (this.blockToSpawn.func_177230_c().func_176196_c(worldIn, position)) {
            worldIn.func_180501_a(position, this.blockToSpawn, 18);
            return true;
        }
        return false;
    }

    public boolean canGenerateInDimension(int dimension) {
        for (int dim : this.config.dimensions) {
            if (dim != dimension) continue;
            return true;
        }
        return false;
    }

    public boolean canGenerateInBiome(Biome biome) {
        if (this.config.biomeOverride) {
            return true;
        }
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        for (String biomeTypeName : this.config.biomeTypes) {
            BiomeDictionary.Type biomeType = this.getBiomeTypeByName(biomeTypeName);
            if (biomeType == null || !biomeTypes.contains(biomeType)) continue;
            return true;
        }
        ResourceLocation biomeRegistryName = biome.getRegistryName();
        for (ResourceLocation biomeName : this.config.getBiomes()) {
            if (!biomeName.equals((Object)biomeRegistryName)) continue;
            return true;
        }
        return false;
    }

    private BiomeDictionary.Type getBiomeTypeByName(String biomeTypeName) {
        for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.getAll()) {
            if (!biomeType.getName().equals(biomeTypeName)) continue;
            return biomeType;
        }
        return null;
    }
}

