/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.world.generator;

import java.util.Random;
import java.util.Set;
import meldexun.better_diving.util.BetterDivingConfig;
import meldexun.better_diving.util.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGeneratorSandLayer
extends WorldGenerator {
    protected final IBlockState blockToSpawn;
    protected final BetterDivingConfig.Ores.SandLayer config;

    public WorldGeneratorSandLayer(IBlockState blockToSpawn, BetterDivingConfig.Ores.SandLayer config) {
        this.blockToSpawn = blockToSpawn;
        this.config = config;
    }

    public void generate(World world, Random rand, int chunkX, int chunkZ) {
        if (this.config.isEnabled() && this.canGenerateInDimension(world.field_73011_w.getDimension())) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int seaLevel = Math.max(world.func_181545_F() - 1, 1);
                    BlockPos pos = new BlockPos(chunkX * 16 + 8 + x, seaLevel, chunkZ * 16 + 8 + z);
                    Biome biome = world.func_72959_q().func_180631_a(pos);
                    if (!this.canGenerateInBiome(biome) || world.func_180495_p((pos = BlockHelper.getSeaBed(world, pos).func_177977_b()).func_177984_a()).func_185904_a() != Material.field_151586_h || !this.isHeightValid(seaLevel, pos.func_177956_o())) continue;
                    this.func_180709_b(world, rand, pos);
                }
            }
        }
    }

    protected boolean isHeightValid(int seaLevel, int y) {
        if (this.config.seaLevelRelative) {
            return y <= seaLevel - this.config.minHeight && y >= seaLevel - this.config.maxHeight;
        }
        return y >= this.config.minHeight && y <= this.config.maxHeight;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        Block block = worldIn.func_180495_p(position).func_177230_c();
        if (block == Blocks.field_150351_n || block == Blocks.field_150346_d || block == Blocks.field_150348_b || BlockHelper.isOreDictionaried(new String[]{"gravel", "dirt", "stone"}, new ItemStack(block))) {
            return worldIn.func_180501_a(position, this.blockToSpawn, 18);
        }
        return false;
    }

    public boolean canGenerateInDimension(int dimension) {
        for (int dim : this.config.dimensions) {
            if (dim != dimension) continue;
            return true;
        }
        return false;
    }

    public boolean canGenerateInBiome(Biome biome) {
        if (this.config.biomeOverride) {
            return true;
        }
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        for (String biomeTypeName : this.config.biomeTypes) {
            BiomeDictionary.Type biomeType = this.getBiomeTypeByName(biomeTypeName);
            if (biomeType == null || !biomeTypes.contains(biomeType)) continue;
            return true;
        }
        ResourceLocation biomeRegistryName = biome.getRegistryName();
        for (ResourceLocation biomeName : this.config.getBiomes()) {
            if (!biomeName.equals((Object)biomeRegistryName)) continue;
            return true;
        }
        return false;
    }

    private BiomeDictionary.Type getBiomeTypeByName(String biomeTypeName) {
        for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.getAll()) {
            if (!biomeType.getName().equals(biomeTypeName)) continue;
            return biomeType;
        }
        return null;
    }
}

