/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.data;

import com.setycz.chickens.ChickensMod;
import com.setycz.chickens.entity.EntityChickensChicken;
import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.item.ItemSpawnEgg;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import com.timwoodcreates.roost.RoostItems;
import com.timwoodcreates.roost.data.DataChicken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="com.setycz.chickens.ChickensRegistry", modid="chickens")
public class DataChickenModded
extends DataChicken {
    private static final String GAIN_KEY = "Gain";
    private static final String GROWTH_KEY = "Growth";
    private static final String STRENGTH_KEY = "Strength";
    private static final String TYPE_KEY = "Type";
    private int gain = 1;
    private int growth = 1;
    private int strength = 1;
    private ChickensRegistryItem chicken;

    public static DataChicken getDataFromEntity(Entity entity) {
        NBTTagCompound tagCompound;
        ChickensRegistryItem chicken;
        if (entity instanceof EntityChickensChicken && (chicken = ChickensRegistry.getByRegistryName((String)(tagCompound = entity.func_189511_e(new NBTTagCompound())).func_74779_i(TYPE_KEY))) != null) {
            return new DataChickenModded(chicken, tagCompound);
        }
        return null;
    }

    public static DataChicken getDataFromTooltipNBT(NBTTagCompound tagCompound) {
        ChickensRegistryItem chicken = ChickensRegistry.getByRegistryName((String)tagCompound.func_74779_i("Chicken"));
        if (chicken != null) {
            return new DataChickenModded(chicken, tagCompound);
        }
        return null;
    }

    public static DataChicken getDataFromStack(ItemStack stack) {
        ChickensRegistryItem chicken = DataChickenModded.chickensRegistryItemForStack(stack);
        if (chicken != null) {
            return new DataChickenModded(chicken, stack.func_77978_p());
        }
        return null;
    }

    public static DataChicken getDataFromName(String name) {
        ChickensRegistryItem chicken = ChickensRegistry.getByRegistryName((String)name);
        if (chicken != null) {
            return new DataChickenModded(chicken, null);
        }
        return null;
    }

    public static void addAllChickens(List<DataChicken> chickens) {
        for (ChickensRegistryItem item : DataChickenModded.getChickenRegistryItems()) {
            chickens.add(new DataChickenModded(item, null));
        }
    }

    private static List<ChickensRegistryItem> getChickenRegistryItems() {
        Comparator<ChickensRegistryItem> comparator = new Comparator<ChickensRegistryItem>(){

            @Override
            public int compare(ChickensRegistryItem left, ChickensRegistryItem right) {
                if (left.getTier() != right.getTier()) {
                    return left.getTier() - right.getTier();
                }
                return left.getEntityName().compareTo(right.getEntityName());
            }
        };
        Collection chickens = ChickensRegistry.getItems();
        ArrayList<ChickensRegistryItem> list = new ArrayList<ChickensRegistryItem>(chickens);
        Collections.sort(list, comparator);
        return list;
    }

    private static ChickensRegistryItem chickensRegistryItemForStack(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        return ChickensRegistry.getByRegistryName((String)tagCompound.func_74779_i("Chicken"));
    }

    private DataChickenModded(ChickensRegistryItem chickenIn, NBTTagCompound compound) {
        super(chickenIn.getEntityName(), "entity." + chickenIn.getEntityName() + ".name");
        this.chicken = chickenIn;
        if (compound != null) {
            this.gain = Math.max(1, Math.min(10, compound.func_74762_e(GAIN_KEY)));
            this.growth = Math.max(1, Math.min(10, compound.func_74762_e(GROWTH_KEY)));
            this.strength = Math.max(1, Math.min(10, compound.func_74762_e(STRENGTH_KEY)));
        }
    }

    @Override
    public String getChickenType() {
        return this.chicken.getRegistryName().toString();
    }

    @Override
    public String getTextureName() {
        return this.chicken.getRegistryName().func_110623_a();
    }

    @Override
    public void addInfoToTooltip(List<String> tooltip) {
        if (this.growth > 1 && this.gain > 1 && this.strength > 1) {
            this.addStatsInfoToTooltip(tooltip);
        } else {
            this.addStatlessInfoToTooltip(tooltip);
        }
    }

    private void addStatsInfoToTooltip(List<String> tooltip) {
        tooltip.add(new TextComponentTranslation("item.roost.chicken.growth", new Object[]{this.growth}).func_150254_d());
        tooltip.add(new TextComponentTranslation("item.roost.chicken.gain", new Object[]{this.gain}).func_150254_d());
        tooltip.add(new TextComponentTranslation("item.roost.chicken.strength", new Object[]{this.strength}).func_150254_d());
    }

    private void addStatlessInfoToTooltip(List<String> tooltip) {
        ChickensRegistryItem parent1 = this.chicken.getParent1();
        ChickensRegistryItem parent2 = this.chicken.getParent2();
        if (parent1 != null && parent2 != null) {
            String n1 = new TextComponentTranslation("entity." + parent1.getEntityName() + ".name", new Object[0]).func_150254_d();
            String n2 = new TextComponentTranslation("entity." + parent2.getEntityName() + ".name", new Object[0]).func_150254_d();
            tooltip.add(new TextComponentTranslation("item.roost.chicken.parent1", new Object[]{n1}).func_150254_d());
            tooltip.add(new TextComponentTranslation("item.roost.chicken.parent2", new Object[]{n2}).func_150254_d());
        }
        if (this.chicken.canSpawn() && this.chicken.getSpawnType() != SpawnType.NONE) {
            String spawnType = this.chicken.getSpawnType().name().toLowerCase();
            tooltip.add(new TextComponentTranslation("item.roost.chicken.spawning." + spawnType, new Object[0]).func_150254_d());
        }
    }

    @Override
    public NBTTagCompound buildTooltipNBT() {
        NBTTagCompound tagCompound = this.createTagCompound();
        tagCompound.func_74778_a("Chicken", this.chicken.getRegistryName().toString());
        return tagCompound;
    }

    @Override
    public EntityChicken buildEntity(World world) {
        EntityChickensChicken chicken = new EntityChickensChicken(world);
        chicken.func_70037_a(this.createTagCompound());
        chicken.setChickenType(this.getChickenType());
        return chicken;
    }

    @Override
    public void spawnEntity(World world, BlockPos pos) {
        EntityChickensChicken chicken = new EntityChickensChicken(world);
        chicken.func_70037_a(this.createTagCompound());
        chicken.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        chicken.func_180482_a(world.func_175649_E(pos), null);
        chicken.setChickenType(this.getChickenType());
        chicken.func_70873_a(this.getLayTime());
        world.func_72838_d((Entity)chicken);
    }

    @Override
    public ItemStack buildChickenStack() {
        ItemStack stack = new ItemStack((Item)RoostItems.ITEM_CHICKEN);
        NBTTagCompound tagCompound = this.createTagCompound();
        tagCompound.func_74778_a("Chicken", this.chicken.getRegistryName().toString());
        stack.func_77982_d(tagCompound);
        return stack;
    }

    @Override
    public boolean hasParents() {
        return this.chicken.getParent1() != null && this.chicken.getParent2() != null;
    }

    @Override
    public List<ItemStack> buildParentChickenStack() {
        if (!this.hasParents()) {
            return null;
        }
        DataChickenModded parent1 = new DataChickenModded(this.chicken.getParent1(), null);
        DataChickenModded parent2 = new DataChickenModded(this.chicken.getParent2(), null);
        return Arrays.asList(((DataChicken)parent1).buildChickenStack(), ((DataChicken)parent2).buildChickenStack());
    }

    @Override
    public ItemStack buildCaughtFromStack() {
        ItemStack stack = new ItemStack(ChickensMod.spawnEgg);
        ItemSpawnEgg.applyEntityIdToItemStack((ItemStack)stack, (ResourceLocation)this.chicken.getRegistryName());
        return stack;
    }

    @Override
    public ItemStack createDropStack() {
        ItemStack stack = this.chicken.createLayItem();
        stack.func_190920_e(this.gain >= 10 ? 3 : (this.gain >= 5 ? 2 : 1));
        return stack;
    }

    public NBTTagCompound createTagCompound() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a(GAIN_KEY, this.gain);
        tagCompound.func_74768_a(GROWTH_KEY, this.growth);
        tagCompound.func_74768_a(STRENGTH_KEY, this.strength);
        return tagCompound;
    }

    @Override
    public int getAddedTime(ItemStack stack) {
        return this.growth * super.getAddedTime(stack);
    }

    @Override
    public int getLayTime() {
        int minLayTime = this.chicken.getMinLayTime();
        int maxLayTime = this.chicken.getMaxLayTime();
        return minLayTime + this.rand.nextInt(maxLayTime - minLayTime);
    }

    @Override
    public boolean isEqual(DataChicken other) {
        if (other instanceof DataChickenModded) {
            DataChickenModded o = (DataChickenModded)other;
            return this.getChickenType().equals(o.getChickenType()) && this.growth == o.growth && this.gain == o.gain && this.strength == o.strength;
        }
        return false;
    }

    public String toString() {
        return "DataChickenModded [name=" + this.getName() + " type=" + this.getChickenType() + ", gain=" + this.gain + ", growth=" + this.growth + ", strength=" + this.strength + "]";
    }

    @Override
    public String getDisplaySummary() {
        return super.getDisplaySummary() + " " + this.growth + "/" + this.gain + "/" + this.strength;
    }
}

