/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.tileentity;

import com.timwoodcreates.roost.RoostConfig;
import com.timwoodcreates.roost.data.DataChicken;
import com.timwoodcreates.roost.tileentity.TileEntityChickenContainer;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityRoost
extends TileEntityChickenContainer {
    private static final String CHICKEN_KEY = "Chicken";
    private static final String COMPLETE_KEY = "Complete";
    private static int CHICKEN_SLOT = 0;

    @Override
    protected void spawnChickenDrop() {
        DataChicken chicken = this.getChickenData(0);
        if (chicken != null) {
            this.putStackInOutput(chicken.createDropStack());
        }
    }

    public DataChicken createChickenData() {
        return this.createChickenData(0);
    }

    public boolean putChickenIn(ItemStack newStack) {
        int itemsAfterAdding;
        int itemsToAdd;
        ItemStack oldStack = this.func_70301_a(CHICKEN_SLOT);
        if (!this.func_94041_b(CHICKEN_SLOT, newStack)) {
            return false;
        }
        if (oldStack.func_190926_b()) {
            this.func_70299_a(CHICKEN_SLOT, newStack.func_77979_a(16));
            this.func_70296_d();
            this.playPutChickenInSound();
            return true;
        }
        if (oldStack.func_77969_a(newStack) && ItemStack.func_77970_a((ItemStack)oldStack, (ItemStack)newStack) && (itemsToAdd = (itemsAfterAdding = Math.min(oldStack.func_190916_E() + newStack.func_190916_E(), 16)) - oldStack.func_190916_E()) > 0) {
            newStack.func_77979_a(itemsToAdd);
            oldStack.func_190917_f(itemsToAdd);
            this.func_70296_d();
            this.playPutChickenInSound();
            return true;
        }
        return false;
    }

    public boolean pullChickenOut(EntityPlayer playerIn) {
        ItemStack spawnStack = this.func_70301_a(CHICKEN_SLOT);
        if (spawnStack.func_190926_b()) {
            return false;
        }
        playerIn.field_71071_by.func_70441_a(spawnStack);
        this.func_70299_a(CHICKEN_SLOT, ItemStack.field_190927_a);
        this.func_70296_d();
        this.playPullChickenOutSound();
        return true;
    }

    private void playPutChickenInSound() {
        this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private void playPullChickenOutSound() {
        this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void addInfoToTooltip(List<String> tooltip, NBTTagCompound tag) {
        if (tag.func_74764_b(CHICKEN_KEY)) {
            DataChicken chicken = DataChicken.getDataFromTooltipNBT(tag.func_74775_l(CHICKEN_KEY));
            tooltip.add(chicken.getDisplaySummary());
        }
        if (tag.func_74764_b(COMPLETE_KEY)) {
            tooltip.add(new TextComponentTranslation("container.roost.progress", new Object[]{this.formatProgress(tag.func_74769_h(COMPLETE_KEY))}).func_150254_d());
        }
    }

    public void storeInfoForTooltip(NBTTagCompound tag) {
        DataChicken chicken = this.getChickenData(CHICKEN_SLOT);
        if (chicken == null) {
            return;
        }
        tag.func_74782_a(CHICKEN_KEY, (NBTBase)chicken.buildTooltipNBT());
        tag.func_74780_a(COMPLETE_KEY, this.getProgress());
    }

    public String func_70005_c_() {
        return "container.roost.roost";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public int func_70302_i_() {
        return 5;
    }

    @Override
    public int getSizeChickenInventory() {
        return 1;
    }

    @Override
    protected int requiredSeedsForDrop() {
        return 0;
    }

    @Override
    protected double speedMultiplier() {
        return RoostConfig.roostSpeed;
    }
}

