/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.api.Coord4D;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiTabElementType;
import mekanism.client.gui.element.tab.TabType;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiMatrixTab
extends GuiTabElementType<TileEntityInductionCasing, MatrixTab> {
    public GuiMatrixTab(IGuiWrapper gui, TileEntityInductionCasing tile, MatrixTab type, ResourceLocation def) {
        super(gui, tile, type, def);
    }

    public static enum MatrixTab implements TabType
    {
        MAIN("GuiEnergyTab.png", 49, "gui.main"),
        STAT("GuiStatsTab.png", 50, "gui.stats");

        private final String description;
        private final String path;
        private final int guiId;

        private MatrixTab(String path, int id, String desc) {
            this.path = path;
            this.guiId = id;
            this.description = desc;
        }

        @Override
        public ResourceLocation getResource() {
            return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, this.path);
        }

        @Override
        public void openGui(TileEntity tile) {
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, this.guiId));
        }

        @Override
        public String getDesc() {
            return LangUtils.localize(this.description);
        }

        @Override
        public int getYPos() {
            return 6;
        }
    }
}

