/*
 * Decompiled with CFR 0.152.
 */
package uniqueebattle.enchantments;

import java.util.function.ToIntFunction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import uniquebase.api.UniqueEnchantment;
import uniquebase.utils.DoubleStat;
import uniquebase.utils.IStat;
import uniquebase.utils.IdStat;
import uniquebase.utils.IntStat;

public class ArtemisSoul
extends UniqueEnchantment {
    public static final ToIntFunction<ItemStack> VALID_ITEMS = T -> {
        if (T.func_77973_b() == Items.field_151079_bi) {
            return 840;
        }
        if (T.func_77973_b() == Items.field_151061_bv) {
            return 1440;
        }
        return 0;
    };
    public static final String PERSISTEN_SOUL_COUNT = "p_souls";
    public static final String TEMPORARY_SOUL_COUNT = "t_souls";
    public static final String TIME_STAMP = "t_soul_date";
    public static final String ENDER_STORAGE = "ender_storage";
    private static final IdStat VALID_MOBS = new IdStat("valid_mobs", ForgeRegistries.ENTITIES, new ResourceLocation[]{new ResourceLocation("minecraft:ender_dragon"), new ResourceLocation("minecraft:wither"), new ResourceLocation("minecraft:shulker"), new ResourceLocation("minecraft:elder_guardian"), new ResourceLocation("minecraft:ravager"), new ResourceLocation("minecraft:evoker")});
    public static final IntStat CAP_BASE = new IntStat(625, "base_limit");
    public static final IntStat CAP_FACTOR = new IntStat(625, "base_limit_expansion");
    public static final DoubleStat CAP_SCALE = new DoubleStat(1.0, "base_limit_scale");
    public static final DoubleStat REAP_SCALE = new DoubleStat(1.0, "reap_scale");
    public static final DoubleStat DROP_SOUL_SCALE = new DoubleStat(1.0, "drop_scale");
    public static final DoubleStat TEMP_SOUL_SCALE = new DoubleStat(1.0, "temp_soul_scale");
    public static final DoubleStat PERM_SOUL_SCALE = new DoubleStat(1.0, "perm_soul_scale");

    public ArtemisSoul() {
        super(new UniqueEnchantment.DefaultData("artemis_soul", Enchantment.Rarity.VERY_RARE, 7, true, 15, 60, 45), EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        this.addStats(new IStat[]{VALID_MOBS, CAP_BASE, CAP_FACTOR, CAP_FACTOR, CAP_SCALE, REAP_SCALE, DROP_SOUL_SCALE, TEMP_SOUL_SCALE, PERM_SOUL_SCALE});
        this.setCategory("battle");
    }

    public static boolean isValidSpecialMob(Entity entity) {
        return VALID_MOBS.contains(EntityList.func_191306_a(entity.getClass()));
    }

    protected boolean canApplyToItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBow && stack.func_77973_b() instanceof ItemTool && stack.func_77973_b() instanceof ItemHoe;
    }
}

