/*
 * Decompiled with CFR 0.152.
 */
package uniqueebattle.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import uniquebase.handler.MathCache;
import uniquebase.utils.MiscUtil;
import uniquebase.utils.StackUtils;
import uniqueebattle.UniqueEnchantmentsBattle;
import uniqueebattle.enchantments.AresFragment;
import uniqueebattle.enchantments.AresGrace;
import uniqueebattle.enchantments.ArtemisSoul;
import uniqueebattle.enchantments.CelestialBlessing;
import uniqueebattle.enchantments.DeepWounds;
import uniqueebattle.enchantments.Fury;
import uniqueebattle.enchantments.GolemSoul;
import uniqueebattle.enchantments.GranisSoul;
import uniqueebattle.enchantments.IfritsBlessing;
import uniqueebattle.enchantments.IfritsJudgement;
import uniqueebattle.enchantments.IronBird;
import uniqueebattle.enchantments.LunaticDespair;
import uniqueebattle.enchantments.StreakersWill;
import uniqueebattle.enchantments.WarsOdium;

public class BattleHandler {
    public static final BattleHandler INSTANCE = new BattleHandler();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Entity entity;
        Object2IntMap.Entry entry;
        int level;
        if (event.phase == TickEvent.Phase.START || event.side.isClient()) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.field_70122_E && player.field_70170_p.func_82737_E() % 40L == 0L && (level = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantmentsBattle.IRON_BIRD, (ItemStack)player.func_184582_a(EntityEquipmentSlot.CHEST))) > 0) {
            player.func_70690_d(new PotionEffect(UniqueEnchantmentsBattle.TOUGHEND, 80, Math.max(MathHelper.func_76128_c((double)(Math.sqrt(level) - 1.0)), 0), true, true));
        }
        if (player.field_70170_p.func_82737_E() % 4800L == 0L && (entry = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantmentsBattle.ARTEMIS_SOUL, (EntityLivingBase)player)).getIntValue() > 0) {
            ItemStack stack = player.func_184582_a((EntityEquipmentSlot)entry.getKey());
            int enderPoints = StackUtils.getInt((ItemStack)stack, (String)"ender_storage", (int)0);
            if (enderPoints > 0) {
                StackUtils.setInt((ItemStack)stack, (String)"ender_storage", (int)Math.max(0, enderPoints - MathHelper.func_76143_f((double)Math.sqrt(entry.getIntValue()))));
            } else {
                StackUtils.setInt((ItemStack)stack, (String)"t_souls", (int)((int)((double)StackUtils.getInt((ItemStack)stack, (String)"t_souls", (int)0) * (-1.0 / ((double)entry.getIntValue() + 1.0) + 1.0))));
            }
        }
        if ((entity = event.player.func_184208_bv()) instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)entity;
            int level2 = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantmentsBattle.GRANIS_SOUL, (ItemStack)((IItemHandler)horse.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(1));
            if (level2 > 0) {
                NBTTagCompound nbt = horse.getEntityData();
                if (nbt.func_74763_f("granis_next_dash") < player.field_70170_p.func_82737_E()) {
                    IAttributeInstance instance = horse.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    if (instance.func_111127_a(GranisSoul.DASH_ID) != null) {
                        instance.func_188479_b(GranisSoul.DASH_ID);
                    }
                    if (UniqueEnchantmentsBattle.GRANIS_SOUL_DASH.test(player)) {
                        int duration = (MathCache.LOG10.getInt(GranisSoul.DASH_DURATION.get() + player.field_71068_ca) - 1) * 20;
                        nbt.func_74772_a("granis_next_dash", player.field_70170_p.func_82737_E() + (long)duration + 20L);
                        nbt.func_74768_a("granis_dash", duration);
                        instance.func_111121_a(new AttributeModifier(GranisSoul.DASH_ID, "Granis Dash", Math.sqrt(GranisSoul.DASH_SPEED.get() + (double)level2), 2));
                        int bleed = GranisSoul.BLEED_DURATION.get(level2);
                        for (EntityLivingBase base : player.field_70170_p.func_175647_a(EntityLivingBase.class, horse.func_174813_aQ().func_186662_g((double)GranisSoul.BLEED_RANGE.get(level2)), T -> T != horse && T != player && EntitySelectors.field_180132_d.test(T))) {
                            base.func_70690_d(new PotionEffect(UniqueEnchantmentsBattle.BLEED, bleed, level2 - 1));
                        }
                    }
                } else {
                    int timeLeft = nbt.func_74762_e("granis_dash");
                    if (timeLeft >= 0) {
                        nbt.func_74768_a("granis_dash", --timeLeft);
                        if (timeLeft <= 0) {
                            horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(GranisSoul.DASH_ID);
                        }
                    }
                }
            } else {
                IAttributeInstance instance = horse.func_110148_a(SharedMonsterAttributes.field_111263_d);
                if (instance.func_111127_a(GranisSoul.DASH_ID) != null) {
                    instance.func_188479_b(GranisSoul.DASH_ID);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tile;
        int count;
        if (event.getWorld() instanceof WorldServer && (count = event.getEntityPlayer().getEntityData().func_74775_l("PlayerPersisted").func_74762_e("judge_loot")) > 0 && (tile = event.getWorld().func_175625_s(event.getPos())) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, event.getFace())) {
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, event.getFace());
            if (handler.getSlots() < 9) {
                return;
            }
            LootTable table = ((WorldServer)event.getWorld()).func_184146_ak().func_186521_a(IfritsJudgement.JUDGEMENT_LOOT);
            for (ItemStack stack : table.func_186462_a(event.getWorld().field_73012_v, new LootContext.Builder((WorldServer)event.getWorld()).func_186470_a(event.getEntityPlayer()).func_186469_a(event.getEntityPlayer().func_184817_da()).func_186471_a())) {
                ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            }
            MiscUtil.getPersistentData((Entity)event.getEntityPlayer()).func_74768_a("judge_loot", count - 1);
            if (event.getEntityPlayer().func_70093_af()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onCritEvent(CriticalHitEvent event) {
        EntityPlayer source = event.getEntityPlayer();
        Object2IntMap ench = MiscUtil.getEnchantments((ItemStack)source.func_184614_ca());
        if (event.isVanillaCritical()) {
            this.dropPlayerHand(event.getTarget(), ench.getInt((Object)UniqueEnchantmentsBattle.FURY));
            return;
        }
        int level = ench.getInt((Object)UniqueEnchantmentsBattle.ARES_FRAGMENT);
        if (level > 0 && source instanceof EntityPlayer) {
            int posRolls;
            EntityPlayer player = source;
            int maxRolls = MathHelper.func_76128_c((double)(Math.sqrt(level * player.field_71068_ca) * AresFragment.BASE_ROLL_MULTIPLIER.get())) + AresFragment.BASE_ROLL.get();
            int negRolls = maxRolls - (posRolls = Math.max(source.field_70170_p.field_73012_v.nextInt(Math.max(1, maxRolls)), MathHelper.func_76128_c((double)Math.sqrt(level))));
            if (negRolls >= posRolls) {
                return;
            }
            event.setResult(Event.Result.ALLOW);
            event.setDamageModifier(1.5f);
            this.dropPlayerHand(event.getTarget(), ench.getInt((Object)UniqueEnchantmentsBattle.FURY));
        }
    }

    protected void dropPlayerHand(Entity target, int level) {
        if (level > 0 && target.field_70170_p.field_73012_v.nextDouble() < (double)Fury.DROP_CHANCE.getDevided(level)) {
            EntityLivingBase other;
            if (target instanceof EntityPlayer) {
                InventoryPlayer player = ((EntityPlayer)target).field_71071_by;
                int firstEmpty = player.func_70447_i();
                if (firstEmpty == -1) {
                    player.field_70458_d.func_71019_a(player.func_70448_g(), false);
                    player.func_70304_b(player.field_70461_c);
                } else {
                    ItemStack stack = player.func_70448_g().func_77946_l();
                    player.func_70304_b(player.field_70461_c);
                    player.func_191971_c(firstEmpty, stack);
                }
            } else if (target instanceof EntityLivingBase && !(other = (EntityLivingBase)target).func_184614_ca().func_190926_b()) {
                if (other.func_184592_cb().func_190926_b()) {
                    other.func_184611_a(EnumHand.OFF_HAND, other.func_184586_b(EnumHand.MAIN_HAND));
                    other.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                } else {
                    EntityItem entity;
                    if (!other.field_70170_p.field_72995_K && (entity = other.func_70099_a(other.func_184614_ca(), 0.0f)) != null) {
                        entity.func_174867_a(30);
                    }
                    other.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityLoot(LootingLevelEvent event) {
        EntityLivingBase base;
        Object2IntMap.Entry entry;
        Entity entity = event.getDamageSource().func_76346_g();
        if (entity instanceof EntityLivingBase && (entry = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantmentsBattle.ARTEMIS_SOUL, (EntityLivingBase)(base = (EntityLivingBase)entity))).getIntValue() > 0) {
            event.setLootingLevel(event.getLootingLevel() + MathCache.LOG10.getInt(1 + StackUtils.getInt((ItemStack)base.func_184582_a((EntityEquipmentSlot)entry.getKey()), (String)"p_souls", (int)0) * entry.getIntValue()));
        }
    }

    @SubscribeEvent
    public void onXPDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        Object2IntMap.Entry entry = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantmentsBattle.ARTEMIS_SOUL, (EntityLivingBase)event.getAttackingPlayer());
        if (entry.getIntValue() > 0) {
            ItemStack stack = event.getAttackingPlayer().func_184582_a((EntityEquipmentSlot)entry.getKey());
            double temp = ArtemisSoul.TEMP_SOUL_SCALE.get((double)StackUtils.getInt((ItemStack)stack, (String)"t_souls", (int)0));
            event.setDroppedExperience(event.getDroppedExperience() * MathCache.LOG10.getInt(100 + MathHelper.func_76143_f((double)((double)entry.getIntValue() * Math.sqrt(ArtemisSoul.PERM_SOUL_SCALE.get((double)StackUtils.getInt((ItemStack)stack, (String)"p_souls", (int)0)) + temp * temp)))) - 1);
        }
    }

    @SubscribeEvent
    public void onArmorDamage(LivingHurtEvent event) {
        PotionEffect effect;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase source = (EntityLivingBase)entity;
            EntityLivingBase target = event.getEntityLiving();
            Object2IntMap ench = MiscUtil.getEnchantments((ItemStack)source.func_184614_ca());
            int level = ench.getInt((Object)UniqueEnchantmentsBattle.ARES_FRAGMENT);
            if (level > 0 && source instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)source;
                int maxRolls = MathHelper.func_76128_c((double)(Math.sqrt(level * player.field_71068_ca) * AresFragment.BASE_ROLL_MULTIPLIER.get())) + AresFragment.BASE_ROLL.get();
                int posRolls = Math.max(source.field_70170_p.field_73012_v.nextInt(Math.max(1, maxRolls)), MathHelper.func_76128_c((double)Math.sqrt(level)));
                int negRolls = maxRolls - posRolls;
                double speed = MiscUtil.getAttribute((EntityLivingBase)source, (IAttribute)SharedMonsterAttributes.field_188790_f);
                float damageFactor = (float)(Math.log(1.0 + Math.sqrt(player.field_71068_ca * level * level) * (1.0 + MiscUtil.getArmorProtection((EntityLivingBase)target) * AresFragment.ARMOR_PERCENTAGE.get())) / (100.0 * speed));
                event.setAmount(event.getAmount() * ((1.0f + damageFactor * (float)posRolls) / (1.0f + damageFactor * (float)negRolls)));
                source.func_184614_ca().func_77972_a(MathHelper.func_76143_f((double)(Math.log(Math.abs((double)posRolls - Math.sqrt(negRolls))) * ((double)(posRolls - negRolls != 0 ? posRolls - negRolls : 1) / speed))), source);
            }
            if ((level = ench.getInt((Object)UniqueEnchantmentsBattle.DEEP_WOUNDS)) > 0 && target.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
                PotionEffect effect2 = target.func_70660_b(UniqueEnchantmentsBattle.BLEED);
                if (effect2 != null) {
                    event.setAmount(event.getAmount() * MathCache.LOG.getFloat(10 + (int)Math.pow(DeepWounds.BLEED_SCALE.get((double)MiscUtil.getPlayerLevel((Entity)source, (int)70)), 2.0) / 100));
                }
                target.func_70690_d(new PotionEffect(UniqueEnchantmentsBattle.BLEED, (int)Math.pow(DeepWounds.DURATION.get(level), 0.4) * 20, effect2 == null ? 0 : effect2.func_76458_c() + 1));
            }
            if (target.func_70027_ad()) {
                int n = level = event.getSource().func_76352_a() ? MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantmentsBattle.IFRITS_BLESSING, (EntityLivingBase)source).getIntValue() : ench.getInt((Object)UniqueEnchantmentsBattle.IFRITS_BLESSING);
                if (level > 0) {
                    event.setAmount(event.getAmount() * ((1.0f + IfritsBlessing.BONUS_DAMAGE.getLogValue(2.8, level)) * (float)(source.func_70027_ad() ? 2 : 1)));
                }
            }
            if ((level = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantmentsBattle.STREAKERS_WILL, (EntityLivingBase)source).getIntValue()) > 0 && source.field_70170_p.field_73012_v.nextDouble() < StreakersWill.CHANCE.getAsDouble((double)level)) {
                EntityLivingBase enemy = target;
                for (EntityEquipmentSlot slot : new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.HEAD}) {
                    ItemStack stack = enemy.func_184582_a(slot);
                    if (stack.func_190926_b()) continue;
                    stack.func_77972_a((int)StreakersWill.LOSS_PER_LEVEL.get((double)level), enemy);
                    break;
                }
            }
            if ((level = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantmentsBattle.ARES_GRACE, (EntityLivingBase)source).getIntValue()) > 0) {
                event.setAmount(event.getAmount() + (float)Math.log(1.0 + Math.sqrt(MiscUtil.getArmorProtection((EntityLivingBase)target) * (double)target.func_110143_aJ()) * (double)MiscUtil.getPlayerLevel((Entity)source, (int)0) * (double)level * AresGrace.DAMAGE.get()));
                source.func_184614_ca().func_77972_a(MathHelper.func_76143_f((double)AresGrace.DURABILITY.get(Math.log(1.0f + (float)level * source.func_110143_aJ()))), source);
            }
            EntityEquipmentSlot slot = null;
            if (event.getSource().func_76352_a()) {
                Object2IntMap.Entry found = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantmentsBattle.IFRITS_BLESSING, (EntityLivingBase)source);
                slot = (EntityEquipmentSlot)found.getKey();
                level = found.getIntValue();
            } else {
                level = ench.getInt((Object)UniqueEnchantmentsBattle.IFRITS_JUDGEMENT);
                Object object = slot = level > 0 ? EntityEquipmentSlot.MAINHAND : null;
            }
            if (level > 0) {
                NBTTagCompound entityNBT = MiscUtil.getPersistentData((Entity)target);
                NBTTagList list = entityNBT.func_150295_c("judge_id", 10);
                boolean found = false;
                String id = source.func_184582_a(slot).func_77973_b().getRegistryName().toString();
                int m = list.func_74745_c();
                for (int i = 0; i < m; ++i) {
                    NBTTagCompound data = list.func_150305_b(i);
                    if (!data.func_74779_i("judge_id").equalsIgnoreCase(id)) continue;
                    found = true;
                    data.func_74768_a("judge_count", data.func_74762_e("judge_count") + 1);
                    break;
                }
                if (!found) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("judge_id", id);
                    data.func_74768_a("judge_count", 1);
                    list.func_74742_a((NBTBase)data);
                    entityNBT.func_74782_a("judge_id", (NBTBase)list);
                }
            }
        }
        if ((effect = event.getEntityLiving().func_70660_b(UniqueEnchantmentsBattle.TOUGHEND)) != null) {
            event.setAmount((float)((double)event.getAmount() * Math.pow(0.9, effect.func_76458_c() + 1)));
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase) {
            Object2IntMap.Entry entry;
            int level;
            EntityLivingBase source = (EntityLivingBase)entity;
            Object2IntMap.Entry found = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantmentsBattle.IFRITS_JUDGEMENT, (EntityLivingBase)source);
            if (found.getIntValue() > 0) {
                int combined;
                NBTTagList list = MiscUtil.getPersistentData((Entity)event.getEntityLiving()).func_150295_c("judge_id", 10);
                int max = 0;
                int m = list.func_74745_c();
                for (int i = 0; i < m; ++i) {
                    max = Math.max(max, list.func_150305_b(i).func_74762_e("judge_count"));
                }
                if (max > IfritsJudgement.LAVA_HITS.get()) {
                    combined = MiscUtil.getCombinedEnchantmentLevel((Enchantment)UniqueEnchantmentsBattle.IFRITS_JUDGEMENT, (EntityLivingBase)source);
                    source.func_70097_a(DamageSource.field_76371_c, IfritsJudgement.LAVA_DAMAGE.getAsFloat((float)found.getIntValue() * MathCache.LOG_MUL_MAX.getFloat(combined)));
                    entity.func_70015_d(Math.max(1, IfritsJudgement.DURATION.get(found.getIntValue()) / 20));
                } else if (max > IfritsJudgement.FIRE_HITS.get()) {
                    combined = MiscUtil.getCombinedEnchantmentLevel((Enchantment)UniqueEnchantmentsBattle.IFRITS_JUDGEMENT, (EntityLivingBase)source);
                    source.func_70097_a(DamageSource.field_76372_a, IfritsJudgement.FIRE_DAMAGE.getAsFloat((float)found.getIntValue() * MathCache.LOG_MUL_MAX.getFloat(combined)));
                    entity.func_70015_d(Math.max(1, IfritsJudgement.DURATION.get(found.getIntValue()) / 20));
                } else if (max > 0) {
                    NBTTagCompound compound = MiscUtil.getPersistentData((Entity)source);
                    compound.func_74768_a("judge_loot", compound.func_74762_e("judge_loot") + 1);
                }
            }
            if ((level = MiscUtil.getCombinedEnchantmentLevel((Enchantment)UniqueEnchantmentsBattle.WARS_ODIUM, (EntityLivingBase)source)) > 0 && !(event.getEntity() instanceof EntityPlayer)) {
                double spawnMod;
                int value;
                NBTTagCompound nbt = MiscUtil.getPersistentData((Entity)source);
                double chance = WarsOdium.SPAWN_CHANCE.getAsDouble((double)nbt.func_74762_e("war_counter")) * MathCache.LOG_ADD_MAX.get(level);
                nbt.func_82580_o("war_counter");
                if (chance >= source.field_70170_p.field_73012_v.nextDouble() && (value = (int)(spawnMod = Math.log(54.6 + WarsOdium.MULTIPLIER.get((double)level)) - 3.0)) > 0) {
                    double extraHealth = WarsOdium.HEALTH_BUFF.getAsDouble(spawnMod);
                    IEntityLivingData data = null;
                    ResourceLocation location = EntityList.func_191301_a((Entity)event.getEntity());
                    Vec3d pos = event.getEntity().func_174791_d();
                    if (location != null) {
                        for (int i = 0; i < value; ++i) {
                            Entity toSpawn = EntityList.func_188429_b((ResourceLocation)location, (World)event.getEntity().field_70170_p);
                            if (!(toSpawn instanceof EntityLiving)) continue;
                            EntityLiving base = (EntityLiving)toSpawn;
                            base.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, MathHelper.func_76142_g((float)(event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                            base.field_70759_as = base.field_70177_z;
                            base.field_70761_aq = base.field_70177_z;
                            data = base.func_180482_a(event.getEntity().field_70170_p.func_175649_E(new BlockPos(toSpawn)), data);
                            base.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(WarsOdium.HEALTH_MOD, "wars_spawn_buff", extraHealth, 2));
                            base.func_70606_j(base.func_110138_aP());
                            event.getEntity().field_70170_p.func_72838_d(toSpawn);
                            base.func_70642_aH();
                        }
                    }
                }
            }
            if ((level = (entry = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantmentsBattle.ARTEMIS_SOUL, (EntityLivingBase)source)).getIntValue()) > 0 && !(event.getEntityLiving() instanceof EntityAgeable)) {
                ItemStack stack = source.func_184582_a((EntityEquipmentSlot)entry.getKey());
                String key = ArtemisSoul.isValidSpecialMob(event.getEntity()) ? "p_souls" : "t_souls";
                int playerLevel = MiscUtil.getPlayerLevel((Entity)source, (int)70);
                int max = (int)Math.max(Math.sqrt((double)playerLevel * ArtemisSoul.CAP_SCALE.get()) * (double)ArtemisSoul.CAP_FACTOR.get(), (double)ArtemisSoul.CAP_BASE.get());
                int gain = MathCache.LOG10.getInt((int)(10.0 + (double)((entity.field_70170_p.field_73012_v.nextInt(MiscUtil.getEnchantmentLevel((Enchantment)Enchantments.field_185304_p, (ItemStack)stack) + 1) + 1) * level) * ArtemisSoul.REAP_SCALE.get() * (double)playerLevel));
                StackUtils.setInt((ItemStack)stack, (String)key, (int)Math.min(StackUtils.getInt((ItemStack)stack, (String)key, (int)0) + gain, max));
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingDamageEvent event) {
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase source = (EntityLivingBase)entity;
            int level = MiscUtil.getCombinedEnchantmentLevel((Enchantment)UniqueEnchantmentsBattle.LUNATIC_DESPAIR, (EntityLivingBase)source);
            if (level > 0) {
                event.setAmount(event.getAmount() * (1.0f + LunaticDespair.BONUS_DAMAGE.getFloat(MathCache.LOG_ADD.getFloat(level))));
                source.field_70172_ad = 0;
                source.func_70097_a(DamageSource.field_76376_m, (float)Math.pow(event.getAmount() * (float)level, 0.25) - 1.0f);
            }
            if ((level = MiscUtil.getCombinedEnchantmentLevel((Enchantment)UniqueEnchantmentsBattle.WARS_ODIUM, (EntityLivingBase)source)) > 0) {
                NBTTagCompound nbt = MiscUtil.getPersistentData((Entity)source);
                nbt.func_74768_a("war_counter", nbt.func_74762_e("war_counter") + 1);
            }
        }
    }

    @SubscribeEvent
    public void onEquippementSwapped(LivingEquipmentChangeEvent event) {
        AbstractAttributeMap attribute = event.getEntityLiving().func_110140_aT();
        Multimap<String, AttributeModifier> mods = this.createModifiersFromStack(event.getEntityLiving(), event.getFrom(), event.getSlot(), event.getEntityLiving().func_130014_f_());
        if (!mods.isEmpty()) {
            attribute.func_111148_a(mods);
        }
        if (!(mods = this.createModifiersFromStack(event.getEntityLiving(), event.getTo(), event.getSlot(), event.getEntityLiving().func_130014_f_())).isEmpty()) {
            attribute.func_111147_b(mods);
        }
    }

    private Multimap<String, AttributeModifier> createModifiersFromStack(EntityLivingBase base, ItemStack stack, EntityEquipmentSlot slot, World world) {
        HashMultimap mods = HashMultimap.create();
        Object2IntMap enchantments = MiscUtil.getEnchantments((ItemStack)stack);
        int level = enchantments.getInt((Object)UniqueEnchantmentsBattle.CELESTIAL_BLESSING);
        if (level > 0) {
            mods.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(CelestialBlessing.SPEED_MOD, "speed_boost", world.func_72935_r() ? 0.0 : CelestialBlessing.SPEED_BONUS.getAsDouble((double)level), 2));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantmentsBattle.IRON_BIRD)) > 0) {
            double armor = IronBird.ARMOR.getAsDouble((double)level);
            mods.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(IronBird.DAMAGE_MOD, "damage_mod", armor, 0));
            mods.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(IronBird.TOUGHNESS_MOD, "toughness_mod", Math.sqrt(IronBird.TOUGHNESS.get(armor)), 0));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantmentsBattle.GOLEM_SOUL)) > 0) {
            mods.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(GolemSoul.SPEED_MOD, "speed_loss", Math.pow(1.0 - GolemSoul.SPEED.get(), level) - 1.0, 2));
            mods.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(GolemSoul.KNOCKBACK_MOD, "knockback_boost", GolemSoul.KNOCKBACK.get((double)level), 0));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantmentsBattle.FURY)) > 0) {
            mods.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(Fury.SPEED_MOD, "fury_faster_speed", Math.pow(Fury.ATTACK_SPEED_SCALE.get(1.43 * (double)level), 0.125), 0));
        }
        return mods;
    }
}

