/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.baublesb.boxes;

import baubles.api.render.IRenderBauble;
import com.zeitheron.baublesb.BSBUtil;
import com.zeitheron.baublesb.BaubleShulkerBoxes;
import com.zeitheron.baublesb.cap.BaubleImpl;
import com.zeitheron.baublesb.cap.IShulkerAnimation;
import com.zeitheron.baublesb.intr.ironchest.GuiIronShulkerBox;
import cpw.mods.ironchest.common.blocks.shulker.IronShulkerBoxType;
import cpw.mods.ironchest.common.gui.shulker.ContainerIronShulkerBox;
import cpw.mods.ironchest.common.items.shulker.ItemIronShulkerBox;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IronShulkerBox
extends BaubleImpl {
    public final String color;
    private Object itemRenderer;
    private static float[][] shifts = new float[][]{{0.3f, 0.45f, 0.3f}, {0.7f, 0.45f, 0.3f}, {0.3f, 0.45f, 0.7f}, {0.7f, 0.45f, 0.7f}, {0.3f, 0.1f, 0.3f}, {0.7f, 0.1f, 0.3f}, {0.3f, 0.1f, 0.7f}, {0.7f, 0.1f, 0.7f}, {0.5f, 0.32f, 0.5f}};
    private static EntityItem customitem = new EntityItem(null);
    final Random random = new Random();

    public IronShulkerBox(ItemStack stack) {
        super(stack, null, 0);
        String colorName = "";
        try {
            Field f = ItemIronShulkerBox.class.getDeclaredField("colorName");
            f.setAccessible(true);
            colorName = "" + f.get(stack.func_77973_b());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.color = colorName;
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return this.getType((ItemStack)stack).size;
    }

    @Override
    public Object createGui(EntityPlayer player, IInventory inv, ItemStack stack) {
        IronShulkerBoxType type = this.getType(stack);
        if (type == null) {
            return null;
        }
        return new GuiIronShulkerBox(player.field_71071_by, inv, type, type.xSize, type.ySize);
    }

    @Override
    public Object createContainer(EntityPlayer player, IInventory inv, ItemStack stack) {
        IronShulkerBoxType type = this.getType(stack);
        if (type == null) {
            return null;
        }
        return new ContainerIronShulkerBox((IInventory)player.field_71071_by, inv, type, type.xSize, type.ySize);
    }

    public IronShulkerBoxType getType(ItemStack stack) {
        int meta = stack.func_77960_j();
        return meta < IronShulkerBoxType.VALUES.length ? IronShulkerBoxType.VALUES[meta] : null;
    }

    @Override
    public ResourceLocation getBoxTextures(ItemStack stack) {
        IronShulkerBoxType type = this.getType(stack);
        if (type == null) {
            return null;
        }
        return new ResourceLocation("ironchest", "textures/model/shulker/" + this.color + "/shulker_" + this.color + type.modelTexture);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void renderWithOffset(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
        IronShulkerBoxType sbt;
        super.renderWithOffset(stack, player, type, partialTicks);
        IShulkerAnimation isa = (IShulkerAnimation)player.getCapability(BaubleShulkerBoxes.ANIMATION_CAPABILITY, null);
        if (isa == null) {
            return;
        }
        NonNullList<ItemStack> topStacks = isa.getTopItems();
        if (topStacks == null) {
            return;
        }
        RenderEntityItem itemRenderer = BSBUtil.cast(this.itemRenderer, RenderEntityItem.class);
        if (itemRenderer == null) {
            itemRenderer = new RenderEntityItem(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af());
            this.itemRenderer = itemRenderer;
        }
        if ((sbt = this.getType(stack)).isTransparent()) {
            GlStateManager.func_179089_o();
            this.random.setSeed(254L);
            int shift = 0;
            float blockScale = 0.7f;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
            if (((ItemStack)topStacks.get(1)).func_190926_b()) {
                shift = 8;
                blockScale = 0.85f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)-0.5f);
            customitem.func_70029_a(player.field_70170_p);
            IronShulkerBox.customitem.field_70290_d = 0.0f;
            for (ItemStack item : topStacks) {
                if (shift > shifts.length || shift > 8) break;
                if (item.func_190926_b()) {
                    ++shift;
                    continue;
                }
                float shiftX = shifts[shift][0];
                float shiftY = shifts[shift][1];
                float shiftZ = shifts[shift][2];
                ++shift;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)shiftX, (float)shiftY, (float)shiftZ);
                GlStateManager.func_179114_b((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)blockScale, (float)blockScale, (float)blockScale);
                customitem.func_92058_a(item);
                itemRenderer.func_76986_a(customitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }
}

