/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.baublesb.cap;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import com.zeitheron.baublesb.BaubleShulkerBoxes;
import com.zeitheron.baublesb.api.IContainer;
import com.zeitheron.baublesb.api.ISoundOpenable;
import com.zeitheron.baublesb.cap.IShulkerAnimation;
import com.zeitheron.baublesb.cap.InventoryItemShulkerBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiShulkerBox;
import net.minecraft.client.model.ModelShulker;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerShulkerBox;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaubleImpl
implements IBauble,
IRenderBauble,
ISoundOpenable,
IContainer {
    public final ItemStack stack;
    public ResourceLocation texture;
    public int size;
    Object model;

    public BaubleImpl(ItemStack stackIn, ResourceLocation textureIn, int slotCount) {
        this.stack = stackIn;
        this.texture = textureIn;
        this.size = slotCount;
    }

    @Override
    public ResourceLocation getBoxTextures(ItemStack stack) {
        return this.texture;
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return this.size;
    }

    @Override
    public InventoryItemShulkerBox getInventory(EntityPlayer player, ItemStack stack) {
        ItemStack item = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(BaubleType.BODY.getValidSlots()[0]);
        return !item.func_190926_b() ? new InventoryItemShulkerBox(item, this){

            @Override
            public int func_70302_i_() {
                return BaubleImpl.this.getSlotCount(this.stack);
            }
        } : null;
    }

    @Override
    public Object createGui(EntityPlayer player, IInventory inv, ItemStack stack) {
        return new GuiShulkerBox(player.field_71071_by, inv);
    }

    @Override
    public Object createContainer(EntityPlayer player, IInventory inv, ItemStack stack) {
        return new ContainerShulkerBox(player.field_71071_by, inv, player);
    }

    @Override
    public SoundEvent getOpenSound() {
        return SoundEvents.field_191262_fB;
    }

    @Override
    public SoundEvent getCloseSound() {
        return SoundEvents.field_191261_fA;
    }

    protected boolean hasChestplate(EntityPlayer player) {
        return !player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
        ModelShulker modelShulker;
        if (type != IRenderBauble.RenderType.BODY || stack.func_190926_b()) {
            return;
        }
        ResourceLocation tex = this.getBoxTextures(stack);
        if (tex == null) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
        GlStateManager.func_179139_a((double)0.35, (double)0.35, (double)0.35);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)(1.84 + (this.hasChestplate(player) ? 0.2 : 0.0)), (double)0.9);
        EnumFacing enumfacing = EnumFacing.UP;
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        float f = 0.9995f;
        GlStateManager.func_179152_a((float)0.9995f, (float)0.9995f, (float)0.9995f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        switch (enumfacing) {
            case DOWN: {
                GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            default: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)-1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        float progress = 0.5f;
        IShulkerAnimation isa = (IShulkerAnimation)player.getCapability(BaubleShulkerBoxes.ANIMATION_CAPABILITY, null);
        if (isa != null) {
            progress = isa.getCurrentProgress(partialTicks);
        }
        if (this.model instanceof ModelShulker) {
            modelShulker = (ModelShulker)this.model;
        } else {
            this.model = new ModelShulker();
            modelShulker = this.model;
        }
        ModelShulker model = modelShulker;
        mc.func_110434_K().func_110577_a(tex);
        GlStateManager.func_179094_E();
        model.field_187067_b.func_78785_a(0.0625f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-progress * 0.5f), (float)0.0f);
        GlStateManager.func_179114_b((float)(270.0f * progress), (float)0.0f, (float)1.0f, (float)0.0f);
        model.field_187068_c.func_78785_a(0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.renderWithOffset(stack, player, type, partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderWithOffset(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }
}

