/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item;

import com.github.fnar.minecraft.item.EquipmentType;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public enum ToolType {
    AXE,
    HOE,
    PICKAXE,
    SHOVEL;


    public static ToolType random(Random random) {
        int choice = random.nextInt(ToolType.values().length);
        return ToolType.values()[choice];
    }

    public Item asItem(Quality quality) {
        switch (this) {
            case AXE: {
                return EquipmentType.asItem(quality, Items.field_151053_p, Items.field_151049_t, Items.field_151036_c, Items.field_151006_E, Items.field_151056_x);
            }
            case HOE: {
                return EquipmentType.asItem(quality, Items.field_151017_I, Items.field_151018_J, Items.field_151019_K, Items.field_151013_M, Items.field_151012_L);
            }
            case PICKAXE: {
                return EquipmentType.asItem(quality, Items.field_151039_o, Items.field_151050_s, Items.field_151035_b, Items.field_151005_D, Items.field_151046_w);
            }
            case SHOVEL: {
                return EquipmentType.asItem(quality, Items.field_151038_n, Items.field_151051_r, Items.field_151037_a, Items.field_151011_C, Items.field_151047_v);
            }
        }
        throw new IllegalArgumentException("Unexpected ToolType: " + (Object)((Object)this));
    }

    public Equipment asEquipment() {
        switch (this) {
            case AXE: {
                return Equipment.AXE;
            }
            case HOE: {
                return Equipment.HOE;
            }
            case PICKAXE: {
                return Equipment.PICK;
            }
            case SHOVEL: {
                return Equipment.SHOVEL;
            }
        }
        throw new IllegalArgumentException("Unexpected ToolType: " + (Object)((Object)this));
    }
}

