/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.loot.special.armour;

import com.github.fnar.roguelike.loot.special.SpecialEquipment;
import com.github.fnar.roguelike.loot.special.armour.SpecialBoots;
import com.github.fnar.roguelike.loot.special.armour.SpecialChestplate;
import com.github.fnar.roguelike.loot.special.armour.SpecialHelmet;
import com.github.fnar.roguelike.loot.special.armour.SpecialLeggings;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class SpecialArmour
extends SpecialEquipment {
    public static ItemStack createArmour(Random random, int level) {
        Quality quality = ItemArmour.rollArmourQuality(random, level);
        return SpecialArmour.createArmour(random, quality);
    }

    public static ItemStack createArmour(Random random, Quality quality) {
        switch (random.nextInt(4)) {
            case 0: {
                return new SpecialHelmet(random, quality).complete();
            }
            case 1: {
                return new SpecialChestplate(random, quality).complete();
            }
            case 2: {
                return new SpecialLeggings(random, quality).complete();
            }
            case 3: {
                return new SpecialBoots(random, quality).complete();
            }
        }
        return null;
    }

    protected SpecialArmour withArmourPrefix() {
        this.withPrefix(this.getArmourPrefix());
        return this;
    }

    private String getArmourPrefix() {
        switch (this.quality) {
            case WOOD: {
                return "Surplus";
            }
            case STONE: {
                return "Riveted";
            }
            case IRON: {
                return "Gothic";
            }
            case GOLD: {
                return "Jewelled";
            }
            case DIAMOND: {
                return "Crystal";
            }
        }
        return "Strange";
    }

    protected void withRandomColourIfWood() {
        if (this.quality == Quality.WOOD) {
            this.withRandomColor();
        }
    }

    protected void withProtection(Random random) {
        this.withEnchantment(Enchant.getEnchant(Enchant.PROTECTION), Enchant.getProtectionLevel(this.quality, random));
        this.withSuffix("of Defense");
    }

    protected void withProjectileProtection(Random random) {
        this.withEnchantment(Enchant.getEnchant(Enchant.PROJECTILEPROTECTION), Enchant.getProtectionLevel(this.quality, random));
        this.withSuffix("of Deflection");
    }

    protected void withBlastProtection(Random random) {
        this.withEnchantment(Enchant.getEnchant(Enchant.BLASTPROTECTION), Enchant.getProtectionLevel(this.quality, random));
        this.withSuffix("of Integrity");
    }

    protected void withFlameProtection(Random random) {
        this.withEnchantment(Enchant.getEnchant(Enchant.FIREPROTECTION), Enchant.getProtectionLevel(this.quality, random));
        this.withSuffix("of Flamewarding");
    }

    protected void withArmorEnchantments(Random random) {
        if (random.nextInt(10) == 0) {
            this.withFlameProtection(random);
        } else if (random.nextInt(10) == 0) {
            this.withBlastProtection(random);
        } else if (random.nextInt(3) == 0) {
            this.withProjectileProtection(random);
        } else {
            this.withProtection(random);
        }
    }
}

