/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.loot.special.armour;

import com.github.fnar.roguelike.loot.special.armour.SpecialArmour;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemTool;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public class SpecialBoots
extends SpecialArmour {
    public SpecialBoots(Random random, int level) {
        this(random, ItemTool.rollToolQuality(random, level));
    }

    public SpecialBoots(Random random, Quality quality) {
        this.withQuality(quality);
        this.withItem(this.getSpecialBootsItem());
        this.withName(this.getSpecialBootsName());
        this.withBootsEnchantments(random);
        this.withCommonEnchantments(random);
        this.withArmourPrefix();
        this.withRandomColourIfWood();
    }

    private void withBootsEnchantments(Random random) {
        if (random.nextInt(20) == 0) {
            this.withFeatherFalling(random);
        } else {
            this.withArmorEnchantments(random);
        }
    }

    private void withFeatherFalling(Random random) {
        this.withEnchantment(Enchant.getEnchant(Enchant.FEATHERFALLING), this.quality == Quality.DIAMOND ? 4 : 1 + random.nextInt(3));
        this.withEnchantment(Enchant.getEnchant(Enchant.PROTECTION), Enchant.getProtectionLevel(this.quality, random));
        this.withSuffix("of Lightness");
    }

    private Item getSpecialBootsItem() {
        switch (this.quality) {
            case DIAMOND: {
                return Items.field_151175_af;
            }
            case GOLD: {
                return Items.field_151151_aj;
            }
            case IRON: {
                return Items.field_151167_ab;
            }
            case STONE: {
                return Items.field_151029_X;
            }
        }
        return Items.field_151021_T;
    }

    private String getSpecialBootsName() {
        switch (this.quality) {
            case DIAMOND: {
                return "Boots";
            }
            case GOLD: 
            case IRON: {
                return "Sabatons";
            }
            case STONE: {
                return "Greaves";
            }
        }
        return "Shoes";
    }
}

