/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.loot.special.armour;

import com.github.fnar.roguelike.loot.special.armour.SpecialArmour;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public class SpecialHelmet
extends SpecialArmour {
    public SpecialHelmet(Random random, int level) {
        this(random, ItemArmour.rollArmourQuality(random, level));
    }

    public SpecialHelmet(Random random, Quality quality) {
        this.withQuality(quality);
        this.withItem(this.getSpecialHelmetItem());
        this.withName(this.getSpecialHelmetName());
        this.withHelmetEnchantments(random);
        this.withCommonEnchantments(random);
        this.withArmourPrefix();
        this.withRandomColourIfWood();
    }

    private void withHelmetEnchantments(Random random) {
        if (random.nextInt(20) == 0) {
            this.withDiving(random);
        } else {
            this.withArmorEnchantments(random);
        }
    }

    private void withDiving(Random random) {
        this.withEnchantment(Enchant.getEnchant(Enchant.RESPIRATION), 3);
        this.withEnchantment(Enchant.getEnchant(Enchant.AQUAAFFINITY), 1);
        this.withEnchantment(Enchant.getEnchant(Enchant.PROTECTION), Enchant.getProtectionLevel(this.quality, random));
        this.withSuffix("of Diving");
    }

    private Item getSpecialHelmetItem() {
        switch (this.quality) {
            case DIAMOND: {
                return Items.field_151161_ac;
            }
            case GOLD: {
                return Items.field_151169_ag;
            }
            case IRON: {
                return Items.field_151028_Y;
            }
            case STONE: {
                return Items.field_151020_U;
            }
        }
        return Items.field_151024_Q;
    }

    private String getSpecialHelmetName() {
        switch (this.quality) {
            case DIAMOND: {
                return "Helm";
            }
            case GOLD: {
                return "Crown";
            }
            case IRON: {
                return "Sallet";
            }
            case STONE: {
                return "Coif";
            }
        }
        return "Skullcap";
    }
}

