/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.loot.special.armour;

import com.github.fnar.roguelike.loot.special.armour.SpecialArmour;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public class SpecialLeggings
extends SpecialArmour {
    public SpecialLeggings(Random random, int level) {
        this(random, ItemArmour.rollArmourQuality(random, level));
    }

    public SpecialLeggings(Random random, Quality quality) {
        this.withQuality(quality);
        this.withItem(this.getSpecialLeggingsItem());
        this.withName(this.getSpecialLeggingsName());
        this.withLeggingsEnchantments(random);
        this.withCommonEnchantments(random);
        this.withArmourPrefix();
        this.withRandomColourIfWood();
    }

    private void withLeggingsEnchantments(Random random) {
        this.withArmorEnchantments(random);
    }

    private Item getSpecialLeggingsItem() {
        switch (this.quality) {
            case DIAMOND: {
                return Items.field_151173_ae;
            }
            case GOLD: {
                return Items.field_151149_ai;
            }
            case IRON: {
                return Items.field_151165_aa;
            }
            case STONE: {
                return Items.field_151022_W;
            }
        }
        return Items.field_151026_S;
    }

    private String getSpecialLeggingsName() {
        switch (this.quality) {
            case DIAMOND: {
                return "Leggings";
            }
            case GOLD: 
            case IRON: {
                return "Leg-plates";
            }
            case STONE: {
                return "Chausses";
            }
        }
        return "Pantaloons";
    }
}

