/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.loot.special.weapons;

import com.github.fnar.minecraft.item.WeaponType;
import com.github.fnar.roguelike.loot.special.weapons.SpecialWeapon;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemWeapon;
import greymerk.roguelike.util.TextFormat;
import java.util.Random;

public class SpecialBow
extends SpecialWeapon {
    public SpecialBow(Random random, int level) {
        this(random, ItemWeapon.rollWeaponQuality(random, level));
    }

    public SpecialBow(Random random, Quality quality) {
        this.withQuality(quality);
        this.withItem(WeaponType.getBowItem());
        this.withPower(random);
        switch (quality) {
            case WOOD: 
            case STONE: {
                this.withName("Yew Longbow");
                this.withLore("Superior craftsmanship", TextFormat.DARKGREEN);
                break;
            }
            default: {
                this.withName("Laminated Bow");
                this.withLore("Highly polished", TextFormat.DARKGREEN);
            }
            case GOLD: {
                if (random.nextBoolean()) {
                    this.withEnchantment(Enchant.getEnchant(Enchant.INFINITY), 1);
                    this.withName("Elven Bow");
                    this.withLore("Beautifully crafted", TextFormat.DARKGREEN);
                }
                if (random.nextBoolean()) {
                    this.withEnchantment(Enchant.getEnchant(Enchant.MENDING), 1);
                    this.withName("Faerie Bow");
                    this.withLore("Blessed by the fae", TextFormat.DARKGREEN);
                }
                this.withName("Recurve Bow");
                this.withLore("Curves outward toward the target", TextFormat.DARKGREEN);
                break;
            }
            case DIAMOND: {
                this.withEnchantment(Enchant.getEnchant(Enchant.FLAME), 1);
                this.withName("Eldritch Bow");
                this.withLore("Warm to the touch", TextFormat.DARKGREEN);
            }
        }
        this.withUnbreaking(random);
    }

    public void withPower(Random random) {
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return;
        }
        this.withEnchantment(Enchant.getEnchant(Enchant.POWER), enchantmentLevel);
    }
}

