/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.loot.special.weapons;

import com.github.fnar.minecraft.item.WeaponType;
import com.github.fnar.roguelike.loot.special.weapons.SpecialWeapon;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemWeapon;
import greymerk.roguelike.util.TextFormat;
import java.util.Random;

public class SpecialSword
extends SpecialWeapon {
    public SpecialSword(Random random, int level) {
        this(random, ItemWeapon.rollWeaponQuality(random, level));
    }

    public SpecialSword(Random random, Quality quality) {
        this.withQuality(quality);
        this.withItem(WeaponType.getSwordItem(quality));
        this.withName(quality.getDescriptor() + " Blade");
        this.withSwordEnchantments(random);
        this.withCommonEnchantments(random);
    }

    public void withSwordEnchantments(Random random) {
        this.withSharpness(random);
        this.withLooting(random);
        this.withFiery(random);
    }

    public void withSharpness(Random random) {
        if (random.nextBoolean()) {
            return;
        }
        int enchantmentLevel = random.nextInt(6);
        if (enchantmentLevel <= 0) {
            return;
        }
        this.withEnchantment(Enchant.getEnchant(Enchant.SHARPNESS), enchantmentLevel);
    }

    public void withLooting(Random random) {
        if (random.nextBoolean()) {
            return;
        }
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return;
        }
        this.withEnchantment(Enchant.getEnchant(Enchant.LOOTING), enchantmentLevel);
        if (enchantmentLevel < 3) {
            this.withPrefix("Burglar's");
        } else {
            this.withLore("Once belonged to a king of hidden desert thieves.", TextFormat.DARKGREEN);
            this.withPrefix("Bandit King's");
        }
    }

    public void withFiery(Random random) {
        if (random.nextBoolean()) {
            return;
        }
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return;
        }
        this.withEnchantment(Enchant.getEnchant(Enchant.FIREASPECT), enchantmentLevel);
        if (enchantmentLevel == 1) {
            this.withLore("Warm to the touch", TextFormat.YELLOW);
            this.withPrefix("Ember");
            return;
        }
        if (enchantmentLevel == 2) {
            this.withLore("Almost too hot to hold", TextFormat.RED);
            this.withPrefix("Fiery");
            return;
        }
        this.withLore("From the fiery depths", TextFormat.DARKRED);
        this.withSuffix("of the Inferno");
    }
}

