/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.config;

import greymerk.roguelike.config.Configuration;
import greymerk.roguelike.config.ConfigurationProviderIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class ConfigurationProvider
implements Iterable<Configuration> {
    private static final String true_regex = "^\\s*(?:t(?:rue)?|y(?:es)?)\\s*$";
    private static final String false_regex = "^\\s*(?:f(?:alse)?|no?)\\s*$";
    private static final String true_string = "true";
    private static final String false_string = "false";
    protected Hashtable<String, String> kvp = new Hashtable();
    private Pattern true_pattern = Pattern.compile("^\\s*(?:t(?:rue)?|y(?:es)?)\\s*$");
    private Pattern false_pattern = Pattern.compile("^\\s*(?:f(?:alse)?|no?)\\s*$");

    protected ConfigurationProvider() {
    }

    public boolean ContainsKey(String key) {
        if (key == null) {
            return false;
        }
        return this.kvp.get(key) != null;
    }

    public String Get(String key) {
        if (key == null) {
            return null;
        }
        return this.kvp.get(key);
    }

    public String Get(String key, String fallback) {
        String value = this.Get(key);
        return value == null ? fallback : value;
    }

    public double GetDouble(String key, double fallback) {
        String value = this.Get(key);
        if (value == null) {
            return fallback;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public int GetInteger(String key, int fallback) {
        String value = this.Get(key);
        if (value == null) {
            return fallback;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public boolean GetBoolean(String key, boolean fallback) {
        String value = this.Get(key);
        if (value == null) {
            return fallback;
        }
        if (this.true_pattern.matcher(value).find()) {
            return true;
        }
        if (this.false_pattern.matcher(value).find()) {
            return false;
        }
        return fallback;
    }

    public List<Integer> GetListInteger(String key, List<Integer> fallback) {
        String value = this.Get(key);
        if (value == null) {
            return fallback;
        }
        String[] values = value.split(",");
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (String s : values) {
            try {
                ints.add(Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ints;
    }

    public void Set(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.kvp.remove(key);
            return;
        }
        this.kvp.put(key, value);
    }

    public void Set(String key, double value) {
        this.Set(key, Double.toString(value));
    }

    public void Set(String key, int value) {
        this.Set(key, Integer.toString(value));
    }

    public void Set(String key, boolean value) {
        this.Set(key, value ? true_string : false_string);
    }

    public void Set(String key, List<Integer> intList) {
        this.Set(key, StringUtils.join(intList, (String)","));
    }

    public void Unset(String key) {
        if (key == null) {
            return;
        }
        this.kvp.remove(key);
    }

    @Override
    public Iterator<Configuration> iterator() {
        TreeSet<Map.Entry<String, String>> entries = new TreeSet<Map.Entry<String, String>>(new EntryAlphabetical());
        entries.addAll(this.kvp.entrySet());
        return new ConfigurationProviderIterator(entries.iterator());
    }

    public String GetString(String name, String defaultValue) {
        return Optional.ofNullable(this.Get(name, defaultValue)).orElse(defaultValue);
    }

    private class EntryAlphabetical
    implements Comparator<Map.Entry<String, String>> {
        private EntryAlphabetical() {
        }

        @Override
        public int compare(Map.Entry<String, String> thing, Map.Entry<String, String> other) {
            return thing.getKey().compareTo(other.getKey());
        }
    }
}

