/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.config;

import com.github.fnar.util.Strings;
import com.google.common.collect.Lists;
import greymerk.roguelike.config.ConfigFile;
import greymerk.roguelike.config.INIParser;
import greymerk.roguelike.worldgen.VanillaStructure;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RogueConfig {
    private static final Logger logger = LogManager.getLogger((String)"roguelike");
    public static final String configDirName = "config/roguelike_dungeons";
    public static final String configFileName = "roguelike.cfg";
    public static boolean testing = false;
    private static ConfigFile instance = null;
    public static final RogueConfig BREAK_IF_REQUIRED_MOD_IS_MISSING = new RogueConfig("breakIfRequiredModIsMissing", true);
    public static final RogueConfig DIMENSIONBL = new RogueConfig("dimensionBL", Lists.newArrayList());
    public static final RogueConfig DIMENSIONWL = new RogueConfig("dimensionWL", Lists.newArrayList((Object[])new Integer[]{0}));
    public static final RogueConfig DONATURALSPAWN = new RogueConfig("doNaturalSpawn", true);
    public static final RogueConfig ENCASE = new RogueConfig("encase", false);
    public static final RogueConfig FURNITURE = new RogueConfig("furniture", true);
    public static final RogueConfig GENEROUS = new RogueConfig("generous", true);
    public static final RogueConfig LOOTING = new RogueConfig("looting", 0.085);
    public static final RogueConfig LOWERLIMIT = new RogueConfig("lowerLimit", 60);
    public static final RogueConfig MOBDROPS = new RogueConfig("mobDrops", 0.0);
    public static final RogueConfig PRECIOUSBLOCKS = new RogueConfig("preciousBlocks", true);
    public static final RogueConfig RANDOM = new RogueConfig("random", false);
    public static final RogueConfig ROGUESPAWNERS = new RogueConfig("rogueSpawners", true);
    public static final RogueConfig SPAWNBUILTIN = new RogueConfig("doBuiltinSpawn", true);
    public static final RogueConfig SPAWNCHANCE = new RogueConfig("spawnChance", 1.0);
    public static final RogueConfig SPAWNFREQUENCY = new RogueConfig("spawnFrequency", 10);
    public static final RogueConfig SPAWN_ATTEMPTS = new RogueConfig("spawnAttempts", 10);
    public static final RogueConfig SPAWN_MINIMUM_DISTANCE_FROM_VANILLA_STRUCTURES = new RogueConfig("spawnMinimumDistanceFromVanillaStructures", 50);
    public static final RogueConfig UPPERLIMIT = new RogueConfig("upperLimit", 100);
    public static final RogueConfig VANILLA_STRUCTURES_TO_CHECK_MINIMUM_DISTANCE_FROM = new RogueConfig("vanillaStructuresToCheckMinimumDistanceFrom", VanillaStructure.getAllAsCommaDelimitedString());
    private static final boolean DEFAULT_BOOLEAN = false;
    private static final int DEFAULT_INT = 0;
    private static final double DEFAULT_DOUBLE = 0.0;
    private static final List<Integer> DEFAULT_INT_LIST = Collections.unmodifiableList(Lists.newArrayList());
    private static final String DEFAULT_STRING_VALUE = "";
    private final String name;
    private final Boolean defaultBoolean;
    private final Integer defaultInt;
    private final Double defaultDouble;
    private final List<Integer> defaultIntList;
    private final String defaultStringValue;

    RogueConfig(String name, boolean value) {
        this(name, value, 0, 0.0, null, DEFAULT_STRING_VALUE);
    }

    RogueConfig(String name, int value) {
        this(name, false, value, 0.0, null, DEFAULT_STRING_VALUE);
    }

    RogueConfig(String name, double value) {
        this(name, false, 0, value, null, DEFAULT_STRING_VALUE);
    }

    RogueConfig(String name, List<Integer> value) {
        this(name, false, 0, 0.0, value, DEFAULT_STRING_VALUE);
    }

    RogueConfig(String name, String value) {
        this(name, false, 0, 0.0, DEFAULT_INT_LIST, value);
    }

    RogueConfig(String name, Boolean defaultBoolean, Integer defaultInt, Double defaultDouble, List<Integer> defaultIntList, String defaultStringValue) {
        this.name = name;
        this.defaultBoolean = defaultBoolean;
        this.defaultInt = defaultInt;
        this.defaultDouble = defaultDouble;
        this.defaultIntList = defaultIntList;
        this.defaultStringValue = defaultStringValue;
    }

    public String getName() {
        return this.name;
    }

    private static void setDefaults() {
        if (!instance.ContainsKey(RogueConfig.BREAK_IF_REQUIRED_MOD_IS_MISSING.name)) {
            BREAK_IF_REQUIRED_MOD_IS_MISSING.setBoolean(RogueConfig.BREAK_IF_REQUIRED_MOD_IS_MISSING.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.DONATURALSPAWN.name)) {
            DONATURALSPAWN.setBoolean(RogueConfig.DONATURALSPAWN.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.SPAWNFREQUENCY.name)) {
            SPAWNFREQUENCY.setInt(RogueConfig.SPAWNFREQUENCY.defaultInt);
        }
        if (!instance.ContainsKey(RogueConfig.SPAWNCHANCE.name)) {
            RogueConfig.setDouble(SPAWNCHANCE, RogueConfig.SPAWNCHANCE.defaultDouble);
        }
        if (!instance.ContainsKey(RogueConfig.GENEROUS.name)) {
            GENEROUS.setBoolean(RogueConfig.GENEROUS.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.DIMENSIONWL.name)) {
            DIMENSIONWL.setIntList(RogueConfig.DIMENSIONWL.defaultIntList);
        }
        if (!instance.ContainsKey(RogueConfig.DIMENSIONBL.name)) {
            DIMENSIONBL.setIntList(RogueConfig.DIMENSIONBL.defaultIntList);
        }
        if (!instance.ContainsKey(RogueConfig.PRECIOUSBLOCKS.name)) {
            PRECIOUSBLOCKS.setBoolean(RogueConfig.PRECIOUSBLOCKS.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.LOOTING.name)) {
            RogueConfig.setDouble(LOOTING, RogueConfig.LOOTING.defaultDouble);
        }
        if (!instance.ContainsKey(RogueConfig.UPPERLIMIT.name)) {
            UPPERLIMIT.setInt(RogueConfig.UPPERLIMIT.defaultInt);
        }
        if (!instance.ContainsKey(RogueConfig.LOWERLIMIT.name)) {
            LOWERLIMIT.setInt(RogueConfig.LOWERLIMIT.defaultInt);
        }
        if (!instance.ContainsKey(RogueConfig.ROGUESPAWNERS.name)) {
            ROGUESPAWNERS.setBoolean(RogueConfig.ROGUESPAWNERS.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.ENCASE.name)) {
            ENCASE.setBoolean(RogueConfig.ENCASE.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.FURNITURE.name)) {
            FURNITURE.setBoolean(RogueConfig.FURNITURE.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.RANDOM.name)) {
            RANDOM.setBoolean(RogueConfig.RANDOM.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.SPAWNBUILTIN.name)) {
            SPAWNBUILTIN.setBoolean(RogueConfig.SPAWNBUILTIN.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.SPAWN_MINIMUM_DISTANCE_FROM_VANILLA_STRUCTURES.name)) {
            SPAWN_MINIMUM_DISTANCE_FROM_VANILLA_STRUCTURES.setInt(RogueConfig.SPAWN_MINIMUM_DISTANCE_FROM_VANILLA_STRUCTURES.defaultInt);
        }
        if (!instance.ContainsKey(RogueConfig.SPAWN_ATTEMPTS.name)) {
            SPAWN_ATTEMPTS.setInt(RogueConfig.SPAWN_ATTEMPTS.defaultInt);
        }
        if (!instance.ContainsKey(VANILLA_STRUCTURES_TO_CHECK_MINIMUM_DISTANCE_FROM.getName())) {
            VANILLA_STRUCTURES_TO_CHECK_MINIMUM_DISTANCE_FROM.setString(RogueConfig.VANILLA_STRUCTURES_TO_CHECK_MINIMUM_DISTANCE_FROM.defaultStringValue);
        }
    }

    public static void setDouble(RogueConfig option, double value) {
        RogueConfig.reload(false);
        instance.Set(option.name, value);
    }

    private static void init() {
        File cfile;
        if (testing) {
            return;
        }
        File configDir = new File(configDirName);
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!(cfile = new File("config/roguelike_dungeons/roguelike.cfg")).exists()) {
            try {
                cfile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            instance = new ConfigFile("config/roguelike_dungeons/roguelike.cfg", new INIParser());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RogueConfig.setDefaults();
        try {
            instance.Write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reload(boolean force) {
        if (instance == null || force) {
            RogueConfig.init();
        }
    }

    public double getDouble() {
        if (testing) {
            return this.defaultDouble;
        }
        RogueConfig.reload(false);
        return instance.GetDouble(this.name, this.defaultDouble);
    }

    public boolean getBoolean() {
        if (testing) {
            return this.defaultBoolean;
        }
        RogueConfig.reload(false);
        return instance.GetBoolean(this.name, this.defaultBoolean);
    }

    public void setBoolean(Boolean value) {
        RogueConfig.reload(false);
        instance.Set(this.name, value);
    }

    public int getInt() {
        if (testing) {
            return this.defaultInt;
        }
        RogueConfig.reload(false);
        return instance.GetInteger(this.name, this.defaultInt);
    }

    public void setInt(int value) {
        RogueConfig.reload(false);
        instance.Set(this.name, value);
    }

    public List<Integer> getIntList() {
        if (testing) {
            return this.defaultIntList;
        }
        RogueConfig.reload(false);
        return instance.GetListInteger(this.name, this.defaultIntList);
    }

    public void setIntList(List<Integer> value) {
        RogueConfig.reload(false);
        instance.Set(this.name, value);
    }

    public String getString() {
        if (testing) {
            return this.defaultStringValue;
        }
        return instance.GetString(this.name, this.defaultStringValue);
    }

    private void setString(String defaultStringValue) {
        RogueConfig.reload(false);
        instance.Set(this.name, defaultStringValue);
    }

    public static Set<VanillaStructure> vanillaStructuresToCheckDistanceTo() {
        return Strings.splitCommas(VANILLA_STRUCTURES_TO_CHECK_MINIMUM_DISTANCE_FROM.getString()).stream().map(str -> str.toUpperCase(Locale.ENGLISH)).map(structureName -> {
            try {
                return VanillaStructure.valueOf(structureName);
            }
            catch (IllegalArgumentException exception) {
                logger.error("Invalid value for config `vanillaStructuresToCheckMinimumDistanceFrom`: \"{}\". Skipping...", structureName);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

