/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.base.BaseRoom;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.BoundingBox;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.IBounded;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.IShape;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.shapes.Shape;
import java.util.List;

public class DungeonNode
implements IBounded {
    private final Coord pos;
    private BaseRoom toGenerate;
    private final List<Direction> entrances;

    public DungeonNode(List<Direction> entrances, Coord origin) {
        this.entrances = entrances;
        this.pos = origin.copy();
    }

    public void setDungeon(BaseRoom toGenerate) {
        this.toGenerate = toGenerate;
    }

    public int getSize() {
        if (this.toGenerate == null) {
            return 10;
        }
        return this.toGenerate.getSize();
    }

    public void encase(WorldEditor editor, Theme theme) {
        int size = this.getSize();
        Coord s = this.getPosition().copy();
        Coord e = s.copy();
        s.north(size);
        s.west(size);
        s.down(3);
        e.south(size);
        e.east(size);
        e.up(8);
        RectSolid.newRect(s, e).fill(editor, theme.getPrimary().getWall());
    }

    public List<Direction> getEntrances() {
        return this.entrances;
    }

    public Coord getPosition() {
        return this.pos.copy();
    }

    public BaseRoom getRoom() {
        return this.toGenerate;
    }

    public BoundingBox getBoundingBox(int size) {
        Coord start = this.pos.copy();
        Coord end = this.pos.copy();
        start.north(size);
        start.west(size);
        start.down();
        end.south(size);
        end.east(size);
        end.up(8);
        return new BoundingBox(start, end);
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.getBoundingBox(this.getSize());
    }

    public boolean connectsTo(DungeonTunnel tunnel) {
        return tunnel.hasEnd(this.pos);
    }

    @Override
    public boolean collide(IBounded other) {
        return this.getBoundingBox().collide(other);
    }

    @Override
    public IShape getShape(Shape type) {
        return this.getBoundingBox().getShape(type);
    }

    @Override
    public Coord getStart() {
        return this.getBoundingBox().getStart();
    }

    @Override
    public Coord getEnd() {
        return this.getBoundingBox().getEnd();
    }

    boolean overlaps(int size, DungeonNode other) {
        return this != other && this.getBoundingBox(size).collide(other);
    }

    boolean overlaps(int size, DungeonTunnel tunnel) {
        return !this.connectsTo(tunnel) && this.getBoundingBox(size).collide(tunnel);
    }

    boolean isNotYetGenerated() {
        return this.getRoom() == null;
    }

    public void generate() {
        this.getRoom().generate(this.getPosition(), this.getEntrances());
    }

    boolean hasOverlappingNode(int size, List<DungeonNode> nodes) {
        return nodes.stream().anyMatch(other -> this.overlaps(size, (DungeonNode)other));
    }
}

