/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.decorative.Crop;
import com.github.fnar.minecraft.block.normal.ColoredBlock;
import com.github.fnar.minecraft.block.normal.SlabBlock;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import com.github.fnar.minecraft.block.normal.Wood;
import com.github.fnar.minecraft.block.redstone.TrapdoorBlock;
import com.github.fnar.minecraft.item.Record;
import com.github.fnar.util.Colors;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.base.BaseRoom;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.PotionMixture;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockCheckers;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BTeamRoom
extends BaseRoom {
    public BTeamRoom(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public BaseRoom generate(Coord origin, List<Direction> entrances) {
        StairsBlock stair = StairsBlock.spruce();
        BlockBrush log = Wood.OAK.getLog();
        SingleBlockBrush stonebrick = BlockType.STONE_BRICK.getBrush();
        ColoredBlock cyan = ColoredBlock.stainedHardenedClay().setColor(DyeColor.CYAN);
        SlabBlock slab = SlabBlock.stone().setTop(false).setFullBlock(true).setSeamless(true);
        SingleBlockBrush cobble = BlockType.COBBLESTONE.getBrush();
        SingleBlockBrush lamp = BlockType.REDSTONE_LAMP.getBrush();
        Direction dir = entrances.get(0);
        Coord start = origin.copy();
        Coord end = origin.copy();
        start.translate(dir, 5);
        end.translate(dir.reverse(), 4);
        start.translate(dir.antiClockwise(), 6);
        end.translate(dir.clockwise(), 6);
        end.up(5);
        start.down();
        RectHollow.newRect(start, end).fill(this.worldEditor, stonebrick);
        start = origin.copy();
        start.down();
        end = start.copy();
        start.translate(dir, 4);
        end.translate(dir.reverse(), 3);
        start.translate(dir.antiClockwise(), 5);
        end.translate(dir.clockwise(), 5);
        RectSolid.newRect(start, end).fill(this.worldEditor, cobble);
        start = origin.copy();
        start.down();
        end = start.copy();
        start.translate(dir, 3);
        end.translate(dir.reverse(), 2);
        start.translate(dir.antiClockwise(), 4);
        end.translate(dir.clockwise(), 4);
        RectSolid.newRect(start, end).fill(this.worldEditor, cyan);
        start = origin.copy();
        start.down();
        end = start.copy();
        start.translate(dir, 2);
        end.translate(dir.reverse(), 1);
        start.translate(dir.antiClockwise(), 3);
        end.translate(dir.clockwise(), 3);
        RectSolid.newRect(start, end).fill(this.worldEditor, slab);
        Coord cursor = origin.copy();
        cursor.translate(dir.reverse(), 4);
        this.logWall(this.worldEditor, dir, cursor);
        cursor.translate(dir, 9);
        this.logWall(this.worldEditor, dir.reverse(), cursor);
        cursor = origin.copy();
        cursor.translate(dir.antiClockwise(), 6);
        this.tvWall(this.worldEditor, dir.antiClockwise(), cursor);
        cursor = origin.copy();
        cursor.translate(dir.clockwise(), 6);
        this.bWall(this.worldEditor, dir.clockwise(), cursor);
        this.table(this.worldEditor, dir, origin);
        start = origin.copy();
        start.translate(dir.reverse(), 4);
        end = start.copy();
        start.translate(dir.antiClockwise());
        end.translate(dir.clockwise());
        end.up(2);
        RectSolid.newRect(start, end).fill(this.worldEditor, cobble);
        cursor = origin.copy();
        cursor.translate(dir.reverse(), 4);
        SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
        cursor.up();
        SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
        cursor = origin.copy();
        cursor.translate(dir.reverse());
        cursor.translate(dir.antiClockwise(), 3);
        cursor.up(5);
        log.stroke(this.worldEditor, cursor);
        cursor.translate(dir, 3);
        log.stroke(this.worldEditor, cursor);
        cursor.translate(dir.clockwise(), 6);
        log.stroke(this.worldEditor, cursor);
        cursor.translate(dir.reverse(), 3);
        log.stroke(this.worldEditor, cursor);
        start = origin.copy();
        start.translate(dir.reverse());
        start.up(5);
        end = start.copy();
        start.translate(dir.antiClockwise(), 2);
        end.translate(dir.clockwise(), 2);
        stair.setUpsideDown(true).setFacing(dir).fill(this.worldEditor, new RectSolid(start, end));
        start.translate(dir, 3);
        end.translate(dir, 3);
        stair.setUpsideDown(true).setFacing(dir.reverse()).fill(this.worldEditor, new RectSolid(start, end));
        for (Direction d : dir.orthogonals()) {
            start = origin.copy();
            start.up(5);
            start.translate(d, 3);
            end = start.copy();
            end.translate(dir);
            stair.setUpsideDown(true).setFacing(d.reverse()).fill(this.worldEditor, new RectSolid(start, end));
        }
        start = origin.copy();
        start.up(5);
        end = start.copy();
        start.translate(dir.antiClockwise(), 2);
        end.translate(dir.clockwise(), 2);
        end.translate(dir);
        RectSolid.newRect(start, end).fill(this.worldEditor, lamp);
        cursor = origin.copy();
        cursor.translate(dir, 4);
        cursor.translate(dir.clockwise(), 5);
        BlockType.BOOKSHELF.getBrush().stroke(this.worldEditor, cursor);
        cursor.up();
        BlockType.BREWING_STAND.getBrush().stroke(this.worldEditor, cursor);
        this.worldEditor.setItem(cursor, 1, PotionMixture.getPotionAsRldItemStack(this.worldEditor.getRandom(cursor), PotionMixture.MOONSHINE));
        cursor = origin.copy();
        cursor.translate(dir, 4);
        cursor.translate(dir.antiClockwise(), 4);
        BlockType.JUKEBOX.getBrush().stroke(this.worldEditor, cursor);
        cursor.translate(dir.antiClockwise());
        int level = this.levelSettings.getDifficulty(cursor);
        ChestType chestType = ChestType.EMPTY;
        TreasureChest stal = this.worldEditor.getTreasureChestEditor().createChest(cursor, false, level, dir, chestType);
        stal.setSlot(this.worldEditor.getCapacity(stal) / 2, Record.newRecord().withSong(Record.Song.STAL).asItemStack());
        cursor = origin.copy();
        cursor.translate(dir.reverse(), 3);
        cursor.translate(dir.antiClockwise(), 4);
        TreasureChest bdub = this.worldEditor.getTreasureChestEditor().createChest(cursor, false, level, dir, chestType);
        bdub.setSlot(this.worldEditor.getCapacity(bdub) / 2 - 2, ItemNovelty.getItem(ItemNovelty.BDOUBLEO));
        ItemStack shirt = new ItemStack((Item)Items.field_151027_R);
        shirt.func_151001_c("Pink Sweater");
        Loot.setItemLore(shirt, "\"It's chinese red!\"");
        ItemArmour.dyeArmor(shirt, Colors.CHINESE_RED);
        bdub.setSlot(this.worldEditor.getCapacity(bdub) / 2 + 2, shirt);
        cursor = origin.copy();
        cursor.translate(dir.reverse(), 3);
        cursor.translate(dir.clockwise(), 4);
        TreasureChest genny = this.worldEditor.getTreasureChestEditor().createChest(cursor, false, level, dir, chestType);
        genny.setSlot(this.worldEditor.getCapacity(genny) / 2, ItemNovelty.getItem(ItemNovelty.GENERIKB));
        return this;
    }

    private void table(WorldEditor editor, Direction dir, Coord origin) {
        Coord c;
        StairsBlock stair = StairsBlock.spruce();
        StairsBlock chair = StairsBlock.netherBrick();
        SlabBlock slab = SlabBlock.spruce().setTop(true).setFullBlock(false).setSeamless(false);
        Coord start = origin.copy();
        start.translate(dir.antiClockwise());
        Coord end = origin.copy();
        end.translate(dir.clockwise());
        end.translate(dir);
        RectSolid.newRect(start, end).fill(editor, slab);
        for (Direction d : dir.orthogonals()) {
            start = origin.copy();
            start.translate(d, 2);
            end = start.copy();
            end.translate(dir);
            stair.setUpsideDown(true).setFacing(d).fill(editor, new RectSolid(start, end));
        }
        Coord cursor = origin.copy();
        cursor.translate(dir.reverse(), 2);
        for (Direction d : dir.orthogonals()) {
            c = cursor.copy();
            c.translate(d);
            chair.setUpsideDown(false).setFacing(dir).stroke(editor, c);
        }
        cursor.translate(dir, 5);
        for (Direction d : dir.orthogonals()) {
            c = cursor.copy();
            c.translate(d);
            chair.setUpsideDown(false).setFacing(dir.reverse()).stroke(editor, c);
        }
    }

    private void lamp(WorldEditor editor, Direction dir, Coord origin) {
        SingleBlockBrush fence = Wood.OAK.getFence();
        SingleBlockBrush plank = Wood.SPRUCE.getPlanks();
        Coord cursor = origin.copy();
        plank.stroke(editor, cursor);
        cursor.up();
        fence.stroke(editor, cursor);
        cursor.up();
        this.levelSettings.getTheme().getPrimary().getLightBlock().stroke(editor, cursor);
        for (Direction d : Direction.CARDINAL) {
            if (d == dir.reverse()) continue;
            Coord c = cursor.copy();
            c.translate(d);
            TrapdoorBlock.wood().setOpen().setFacing(d.reverse()).stroke(editor, c);
        }
        cursor.up();
        fence.stroke(editor, cursor);
        cursor.up();
        plank.stroke(editor, cursor);
        cursor.up();
        plank.stroke(editor, cursor);
    }

    private void logWall(WorldEditor editor, Direction dir, Coord origin) {
        Wood wood = Wood.SPRUCE;
        StairsBlock stair = wood.getStairs();
        SingleBlockBrush plank = wood.getPlanks();
        BlockCheckers checkers = new BlockCheckers(wood.getLog().setFacing(Direction.UP), wood.getLog().setFacing(dir.antiClockwise()));
        Coord start = origin.copy();
        start.up();
        Coord end = start.copy();
        start.translate(dir.antiClockwise(), 4);
        end.translate(dir.clockwise(), 4);
        end.up(2);
        RectSolid.newRect(start, end).fill(editor, checkers);
        start = origin.copy();
        end = start.copy();
        start.translate(dir.antiClockwise(), 5);
        end.translate(dir.clockwise(), 5);
        RectSolid.newRect(start, end).fill(editor, plank);
        start.translate(dir);
        end.translate(dir);
        start.up(4);
        end.up(4);
        stair.setUpsideDown(true).setFacing(dir).fill(editor, new RectSolid(start, end));
        for (Direction d : dir.orthogonals()) {
            start = origin.copy();
            start.translate(d, 5);
            start.up();
            end = start.copy();
            end.up(2);
            wood.getLog().setFacing(Direction.UP).fill(editor, new RectSolid(start, end));
            Coord cursor = origin.copy();
            cursor.translate(dir);
            cursor.translate(d, 3);
            this.lamp(editor, dir, cursor);
        }
    }

    private void bWall(WorldEditor editor, Direction dir, Coord origin) {
        BlockJumble bricks = new BlockJumble();
        bricks.addBlock(BlockType.STONE_BRICK.getBrush());
        bricks.addBlock(BlockType.STONE_BRICK_CRACKED.getBrush());
        bricks.addBlock(BlockType.STONE_BRICK_MOSSY.getBrush());
        SingleBlockBrush plank = Wood.SPRUCE.getPlanks();
        SingleBlockBrush b = RogueConfig.GENEROUS.getBoolean() ? BlockType.EMERALD_BLOCK.getBrush() : ColoredBlock.stainedGlass().setColor(DyeColor.LIME);
        Coord start = origin.copy();
        Coord end = start.copy();
        start.translate(dir.clockwise(), 3);
        end.translate(dir.antiClockwise(), 4);
        RectSolid.newRect(start, end).fill(editor, plank);
        start = origin.copy();
        start.up();
        end = start.copy();
        start.translate(dir.clockwise(), 3);
        end.translate(dir.antiClockwise(), 4);
        end.up(3);
        RectSolid.newRect(start, end).fill(editor, bricks);
        Coord cursor = origin.copy();
        cursor.translate(dir.reverse());
        for (int i = 0; i < 5; ++i) {
            if (i % 2 == 0) {
                start = cursor.copy();
                end = start.copy();
                end.translate(dir.antiClockwise(), 2);
                RectSolid.newRect(start, end).fill(editor, b);
            } else {
                Coord c = cursor.copy();
                c.translate(dir.clockwise());
                b.stroke(editor, c);
                c.translate(dir.antiClockwise(), 3);
                b.stroke(editor, c);
            }
            cursor.up();
        }
    }

    private void tvWall(WorldEditor editor, Direction dir, Coord origin) {
        SingleBlockBrush plank = Wood.SPRUCE.getPlanks();
        SingleBlockBrush shelf = BlockType.BOOKSHELF.getBrush();
        BlockBrush jungle = Wood.JUNGLE.getLog().setFacing(dir);
        SingleBlockBrush note = BlockType.NOTEBLOCK.getBrush();
        ColoredBlock black = ColoredBlock.wool().setColor(DyeColor.BLACK);
        BlockBrush bean = Crop.COCOA.getBrush().setFacing(dir);
        SlabBlock slab = Wood.SPRUCE.getSlabs().setTop(true).setFullBlock(false).setSeamless(false);
        Coord start = origin.copy();
        start.translate(dir.reverse());
        start.up(4);
        Coord end = start.copy();
        start.translate(dir.antiClockwise(), 2);
        end.translate(dir.clockwise(), 3);
        RectSolid.newRect(start, end).fill(editor, slab);
        start = origin.copy();
        end = origin.copy();
        start.translate(dir.antiClockwise(), 3);
        end.translate(dir.clockwise(), 4);
        RectSolid.newRect(start, end).fill(editor, plank);
        start.translate(dir.clockwise(), 2);
        end.translate(dir.antiClockwise(), 2);
        RectSolid.newRect(start, end).fill(editor, note);
        start.up();
        end.up(3);
        RectSolid.newRect(start, end).fill(editor, black);
        start = origin.copy();
        start.translate(dir.antiClockwise(), 2);
        start.up();
        end = start.copy();
        end.translate(dir.antiClockwise());
        end.up(2);
        RectSolid.newRect(start, end).fill(editor, shelf);
        Coord cursor = start.copy();
        cursor.up();
        jungle.stroke(editor, cursor);
        cursor.translate(dir.reverse());
        bean.stroke(editor, cursor);
        start = origin.copy();
        start.translate(dir.clockwise(), 3);
        start.up();
        end = start.copy();
        end.translate(dir.clockwise());
        end.up(2);
        RectSolid.newRect(start, end).fill(editor, shelf);
        cursor = start.copy();
        cursor.up();
        jungle.stroke(editor, cursor);
        cursor.translate(dir.reverse());
        bean.stroke(editor, cursor);
    }

    @Override
    public int getSize() {
        return 8;
    }
}

