/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.base.BaseRoom;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;

public class DarkHallRoom
extends BaseRoom {
    public DarkHallRoom(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public BaseRoom generate(Coord origin, List<Direction> entrances) {
        Theme theme = this.levelSettings.getTheme();
        BlockBrush outerWall = theme.getPrimary().getWall();
        BlockBrush wall = theme.getSecondary().getWall();
        BlockBrush floor = theme.getPrimary().getFloor();
        BlockBrush pillar = theme.getSecondary().getPillar();
        BlockBrush accentFloor = theme.getSecondary().getFloor();
        RectHollow r1 = RectHollow.newRect(origin.copy().north(7).west(7).down(), origin.copy().south(7).east(7).up(7));
        outerWall.fill(this.worldEditor, r1, false, true);
        RectHollow r2 = RectHollow.newRect(origin.copy().north(4).west(4).up(6), origin.copy().south(4).east(4).up(9));
        outerWall.fill(this.worldEditor, r2, false, true);
        RectSolid r3 = RectSolid.newRect(origin.copy().north(6).west(6).down(), origin.copy().south(6).east(6).down());
        floor.fill(this.worldEditor, r3, false, true);
        for (Direction entrance : entrances) {
            RectSolid r4 = RectSolid.newRect(origin.copy().translate(entrance.left()), origin.copy().translate(entrance.right()).translate(entrance, 7));
            accentFloor.fill(this.worldEditor, r4, false, true);
        }
        for (Direction side : Direction.CARDINAL) {
            this.generateAccentPillar(origin.copy().translate(side, 6).translate(side.left(), 6), 5);
            this.generateBeam(side, origin.copy().translate(side, 6).up(6), 13);
            this.generateBeam(side, origin.copy().translate(side, 3).up(6), 7);
            this.generateBeam(side, origin.copy().translate(side, 3).up(8), 7);
            this.generateBeam(side, origin.copy().up(8), 7);
            pillar.stroke(this.worldEditor, origin.copy().translate(side, 3).up(7));
            if (!entrances.contains((Object)side)) {
                this.pillar(this.worldEditor, this.levelSettings, side.reverse(), origin.copy().translate(side, 6));
            } else {
                this.generateEntranceArchway(origin.copy().translate(side, 7), side, this.levelSettings);
            }
            wall.fill(this.worldEditor, RectSolid.newRect(origin.copy().translate(side, 6).up(6), origin.copy().translate(side, 4).up(6)));
            for (Direction orthogonal : side.orthogonals()) {
                Coord cursor = origin.copy().translate(side, 6).translate(orthogonal, 3);
                this.pillar(this.worldEditor, this.levelSettings, side.reverse(), cursor);
                wall.fill(this.worldEditor, RectSolid.newRect(cursor.copy().up(6), cursor.copy().up(6).translate(side.reverse(), 6)));
            }
        }
        this.generateDoorways(origin, entrances);
        return this;
    }

    private void generateEntranceArchway(Coord origin, Direction facing, LevelSettings levelSettings) {
        BlockBrush wall = levelSettings.getTheme().getSecondary().getWall();
        BlockBrush pillar = levelSettings.getTheme().getSecondary().getPillar();
        StairsBlock stair = levelSettings.getTheme().getSecondary().getStair();
        Coord aboveOrigin = origin.copy().up(2);
        wall.fill(this.worldEditor, RectSolid.newRect(aboveOrigin.copy().translate(facing.left(), 2), aboveOrigin.copy().translate(facing.right(), 2).up(3)));
        SingleBlockBrush.AIR.stroke(this.worldEditor, aboveOrigin);
        for (Direction orthogonal : facing.orthogonals()) {
            stair.setUpsideDown(true).setFacing(orthogonal.reverse()).stroke(this.worldEditor, aboveOrigin.copy().translate(orthogonal));
            this.pillar(this.worldEditor, levelSettings, orthogonal.reverse(), origin.copy().translate(facing.back()).translate(orthogonal, 3));
            Coord cursor = origin.copy().translate(orthogonal, 2);
            pillar.stroke(this.worldEditor, cursor);
            pillar.stroke(this.worldEditor, cursor.up());
        }
    }

    private void generateBeam(Direction dir, Coord origin, int width) {
        BlockBrush wall = this.levelSettings.getTheme().getSecondary().getWall();
        int left = width / 2;
        int right = width - left - 1;
        Coord beamLeftAnchor = origin.copy().translate(dir.left(), left);
        Coord beamRightAnchor = origin.copy().translate(dir.right(), right);
        RectSolid beam = RectSolid.newRect(beamLeftAnchor, beamRightAnchor);
        wall.fill(this.worldEditor, beam);
    }

    public void generateAccentPillar(Coord origin, int height) {
        BlockBrush pillar = this.levelSettings.getTheme().getSecondary().getPillar();
        RectSolid.newRect(origin.copy(), origin.copy().up(height)).fill(this.worldEditor, pillar);
    }

    private void pillar(WorldEditor editor, LevelSettings settings, Direction dir, Coord origin) {
        BlockBrush wall = settings.getTheme().getSecondary().getWall();
        StairsBlock stair = settings.getTheme().getSecondary().getStair();
        this.generateAccentPillar(origin, 5);
        Coord cursor = origin.copy().up(3).translate(dir);
        stair.setUpsideDown(true).setFacing(dir).stroke(editor, cursor);
        stair.setUpsideDown(false).setFacing(dir.reverse()).stroke(editor, cursor.up());
        stair.setUpsideDown(true).setFacing(dir).stroke(editor, cursor.translate(dir));
        stair.setUpsideDown(false).setFacing(dir.reverse()).stroke(editor, cursor.up());
        cursor.translate(dir);
        if (editor.isAirBlock(cursor)) {
            stair.setUpsideDown(true).setFacing(dir).stroke(editor, cursor);
        } else {
            wall.stroke(editor, cursor);
        }
    }

    @Override
    public int getSize() {
        return 10;
    }
}

