/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.util.IWeighted;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class WeightedRandomLoot
implements Comparable<WeightedRandomLoot>,
IWeighted<ItemStack> {
    private final String name;
    private Item item;
    private Block block;
    private final int damage;
    private final int min;
    private final int max;
    private final int enchLevel;
    private final int weight;
    private NBTTagCompound nbt;

    public WeightedRandomLoot(Block block, int damage, int minStackSize, int maxStackSize, int weight) {
        this.name = block.func_149739_a();
        this.block = block;
        this.damage = damage;
        this.min = minStackSize;
        this.max = maxStackSize;
        this.weight = weight;
        this.enchLevel = 0;
    }

    public WeightedRandomLoot(Item item, int damage, int minStackSize, int maxStackSize, int weight) {
        this(item, damage, minStackSize, maxStackSize, weight, 0);
    }

    public WeightedRandomLoot(Item item, int damage, int minStackSize, int maxStackSize, int weight, int ench) {
        this.name = item.func_77658_a();
        this.item = item;
        this.damage = damage;
        this.min = minStackSize;
        this.max = maxStackSize;
        this.weight = weight;
        this.enchLevel = ench;
    }

    public WeightedRandomLoot(Item item, int damage, int weight) {
        this(item, damage, 1, 1, weight, 0);
    }

    public WeightedRandomLoot(Item item, int weight) {
        this(item, 0, 1, 1, weight, 0);
    }

    public WeightedRandomLoot(JsonObject json, int weight) throws Exception {
        this.name = json.get("name").getAsString();
        ResourceLocation location = new ResourceLocation(this.name);
        this.item = (Item)Item.field_150901_e.func_82594_a((Object)location);
        try {
            this.item.func_77658_a();
        }
        catch (NullPointerException e) {
            throw new DungeonSettingParseException("Invalid item: " + this.name + ". Check for typos, and ensure that it exists in this pack.");
        }
        this.damage = json.has("meta") ? json.get("meta").getAsInt() : 0;
        this.weight = weight;
        int n = this.enchLevel = json.has("ench") ? json.get("ench").getAsInt() : 0;
        if (json.has("min") && json.has("max")) {
            this.min = json.get("min").getAsInt();
            this.max = json.get("max").getAsInt();
        } else {
            this.min = 1;
            this.max = 1;
        }
        if (json.has("nbt")) {
            this.nbt = JsonToNBT.func_180713_a((String)json.get("nbt").getAsString());
        }
    }

    public WeightedRandomLoot(Block block, int i) {
        this(Item.func_150899_d((int)Block.func_149682_b((Block)block)), i);
    }

    private int getStackSize(Random rand) {
        if (this.max == 1) {
            return 1;
        }
        int difference = this.max - this.min;
        return (difference > 0 ? rand.nextInt(difference) : 0) + this.min;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public ItemStack get(Random rand) {
        ItemStack item = null;
        if (this.item != null) {
            item = new ItemStack(this.item, this.getStackSize(rand), this.damage);
        }
        if (this.block != null) {
            item = new ItemStack(this.block, this.getStackSize(rand), this.damage);
        }
        try {
            if (this.enchLevel > 0 && this.enchLevel <= 30) {
                Enchant.enchantItem(rand, item, this.enchLevel);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.nbt != null) {
            item.func_77982_d(this.nbt);
        }
        return item;
    }

    @Override
    public int compareTo(WeightedRandomLoot other) {
        if (this.weight > other.weight) {
            return -1;
        }
        if (this.weight < other.weight) {
            return 1;
        }
        return 0;
    }
}

