/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.roguelike.loot.special.armour.SpecialArmour;
import com.github.fnar.util.Color;
import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemArmour
extends ItemBase {
    private static final Map<Integer, IWeighted<Quality>> armourQuality = new HashMap<Integer, IWeighted<Quality>>();
    private Equipment equipment;
    private boolean enchant;
    private Quality quality;

    public ItemArmour(int weight, int level) {
        super(weight, level);
    }

    public ItemArmour(JsonObject data, int weight) throws Exception {
        super(weight);
        boolean bl = this.enchant = !data.has("ench") || data.get("ench").getAsBoolean();
        if (!data.has("level")) {
            throw new Exception("Armour requires a level");
        }
        this.level = data.get("level").getAsInt();
        if (data.has("equipment")) {
            try {
                this.equipment = Equipment.valueOf(data.get("equipment").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Equipment as: " + data.get("equipment").getAsString());
            }
        }
        if (data.has("quality")) {
            this.level = data.get("level").getAsInt();
            try {
                this.quality = Quality.valueOf(data.get("quality").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Quality as: " + data.get("quality").getAsString());
            }
        }
    }

    public static ItemStack create(Random random, int level, ArmourType armourType, boolean enchant, Quality quality) {
        ItemStack itemStack = new ItemStack(armourType.asItem(quality));
        ItemArmour.dyeArmor(quality, itemStack, Color.random(random));
        if (enchant) {
            return Enchant.enchantItem(random, itemStack, Enchant.getLevel(random, level));
        }
        return itemStack;
    }

    public static ItemStack create(ArmourType armourType, Quality quality, Color color) {
        ItemStack itemStack = new ItemStack(armourType.asItem(quality));
        ItemArmour.dyeArmor(quality, itemStack, color);
        return itemStack;
    }

    public static ItemStack getRandom(Random random, int level, int enchantLevel, ArmourType armourType, Color color) {
        Quality quality = ItemArmour.rollArmourQuality(random, level);
        ItemStack itemStack = new ItemStack(armourType.asItem(quality));
        ItemArmour.dyeArmor(quality, itemStack, color);
        if (enchantLevel > 0) {
            Enchant.enchantItem(random, itemStack, enchantLevel);
        }
        return itemStack;
    }

    private static void dyeArmor(Quality armourQuality, ItemStack item, Color random2) {
        if (armourQuality == Quality.WOOD) {
            ItemArmour.dyeArmor(item, random2);
        }
    }

    public static ItemStack dyeArmor(ItemStack armor, Color color) {
        NBTTagCompound nbtdata = armor.func_77978_p();
        if (nbtdata == null) {
            nbtdata = new NBTTagCompound();
            armor.func_77982_d(nbtdata);
        }
        NBTTagCompound nbtDisplay = nbtdata.func_74775_l("display");
        if (!nbtdata.func_74764_b("display")) {
            nbtdata.func_74782_a("display", (NBTBase)nbtDisplay);
        }
        nbtDisplay.func_74768_a("color", color.asInt());
        return armor;
    }

    public static void loadArmourQualityOddsTable() {
        for (int i = 0; i < 5; ++i) {
            WeightedRandomizer<Quality> armour = new WeightedRandomizer<Quality>();
            switch (i) {
                case 0: {
                    armour.add(new WeightedChoice<Quality>(Quality.WOOD, 250));
                    armour.add(new WeightedChoice<Quality>(Quality.STONE, 50));
                    armour.add(new WeightedChoice<Quality>(Quality.IRON, 20));
                    armour.add(new WeightedChoice<Quality>(Quality.GOLD, 3));
                    armour.add(new WeightedChoice<Quality>(Quality.DIAMOND, 1));
                    break;
                }
                case 1: {
                    armour.add(new WeightedChoice<Quality>(Quality.WOOD, 150));
                    armour.add(new WeightedChoice<Quality>(Quality.STONE, 30));
                    armour.add(new WeightedChoice<Quality>(Quality.IRON, 10));
                    armour.add(new WeightedChoice<Quality>(Quality.GOLD, 3));
                    armour.add(new WeightedChoice<Quality>(Quality.DIAMOND, 1));
                    break;
                }
                case 2: {
                    armour.add(new WeightedChoice<Quality>(Quality.WOOD, 50));
                    armour.add(new WeightedChoice<Quality>(Quality.STONE, 30));
                    armour.add(new WeightedChoice<Quality>(Quality.IRON, 20));
                    armour.add(new WeightedChoice<Quality>(Quality.GOLD, 3));
                    armour.add(new WeightedChoice<Quality>(Quality.DIAMOND, 1));
                    break;
                }
                case 3: {
                    armour.add(new WeightedChoice<Quality>(Quality.WOOD, 20));
                    armour.add(new WeightedChoice<Quality>(Quality.STONE, 10));
                    armour.add(new WeightedChoice<Quality>(Quality.IRON, 10));
                    armour.add(new WeightedChoice<Quality>(Quality.GOLD, 5));
                    armour.add(new WeightedChoice<Quality>(Quality.DIAMOND, 3));
                    break;
                }
                case 4: {
                    armour.add(new WeightedChoice<Quality>(Quality.WOOD, 2));
                    armour.add(new WeightedChoice<Quality>(Quality.STONE, 3));
                    armour.add(new WeightedChoice<Quality>(Quality.IRON, 10));
                    armour.add(new WeightedChoice<Quality>(Quality.GOLD, 3));
                    armour.add(new WeightedChoice<Quality>(Quality.DIAMOND, 3));
                }
            }
            armourQuality.put(i, armour);
        }
    }

    public static Quality rollArmourQuality(Random rand, int level) {
        return armourQuality.get(level).get(rand);
    }

    @Override
    public ItemStack getLootItem(Random rand, int level) {
        if (this.equipment != null || this.quality != null) {
            Quality quality = Optional.ofNullable(this.quality).orElseGet(() -> Quality.get(level));
            ArmourType armourType = this.equipment == null ? ArmourType.random(rand) : this.equipment.asArmourType();
            if (armourType == null) {
                armourType = ArmourType.random(rand);
            }
            return ItemArmour.create(rand, level, armourType, this.enchant, quality);
        }
        int enchantLevel = Enchant.getLevel(rand, level);
        boolean isSpecialArmour = enchantLevel > 0 && rand.nextInt(20 + level * 10) == 0;
        return isSpecialArmour ? SpecialArmour.createArmour(rand, level) : ItemArmour.getRandom(rand, level, enchantLevel, ArmourType.random(rand), Color.random(rand));
    }

    static {
        ItemArmour.loadArmourQualityOddsTable();
    }
}

