/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import com.github.fnar.minecraft.item.ToolType;
import com.github.fnar.roguelike.loot.special.tools.SpecialTool;
import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemTool
extends ItemBase {
    private static final Map<Integer, IWeighted<Quality>> toolQuality = new HashMap<Integer, IWeighted<Quality>>();
    private Equipment type;
    private boolean enchant;
    private Quality quality;

    public ItemTool(int weight, int level) {
        super(weight, level);
    }

    public ItemTool(JsonObject data, int weight) throws Exception {
        super(weight);
        boolean bl = this.enchant = !data.has("ench") || data.get("ench").getAsBoolean();
        if (!data.has("level")) {
            throw new Exception("Tool Loot requires a level");
        }
        this.level = data.get("level").getAsInt();
        if (data.has("equipment")) {
            try {
                this.type = Equipment.valueOf(data.get("equipment").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Equipment as: " + data.get("equipment").getAsString());
            }
        }
        if (data.has("quality")) {
            try {
                this.quality = Quality.valueOf(data.get("quality").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Quality as: " + data.get("quality").getAsString());
            }
        }
    }

    public static void loadToolQualityOddsTable() {
        for (int i = 0; i < 5; ++i) {
            WeightedRandomizer<Quality> tool = new WeightedRandomizer<Quality>();
            switch (i) {
                case 0: {
                    tool.add(new WeightedChoice<Quality>(Quality.WOOD, 10));
                    tool.add(new WeightedChoice<Quality>(Quality.STONE, 20));
                    tool.add(new WeightedChoice<Quality>(Quality.IRON, 10));
                    tool.add(new WeightedChoice<Quality>(Quality.GOLD, 3));
                    tool.add(new WeightedChoice<Quality>(Quality.DIAMOND, 1));
                    break;
                }
                case 1: {
                    tool.add(new WeightedChoice<Quality>(Quality.WOOD, 2));
                    tool.add(new WeightedChoice<Quality>(Quality.STONE, 10));
                    tool.add(new WeightedChoice<Quality>(Quality.IRON, 10));
                    tool.add(new WeightedChoice<Quality>(Quality.GOLD, 3));
                    tool.add(new WeightedChoice<Quality>(Quality.DIAMOND, 1));
                    break;
                }
                case 2: {
                    tool.add(new WeightedChoice<Quality>(Quality.WOOD, 1));
                    tool.add(new WeightedChoice<Quality>(Quality.STONE, 5));
                    tool.add(new WeightedChoice<Quality>(Quality.IRON, 10));
                    tool.add(new WeightedChoice<Quality>(Quality.GOLD, 5));
                    tool.add(new WeightedChoice<Quality>(Quality.DIAMOND, 3));
                    break;
                }
                case 3: {
                    tool.add(new WeightedChoice<Quality>(Quality.WOOD, 1));
                    tool.add(new WeightedChoice<Quality>(Quality.STONE, 3));
                    tool.add(new WeightedChoice<Quality>(Quality.IRON, 10));
                    tool.add(new WeightedChoice<Quality>(Quality.GOLD, 5));
                    tool.add(new WeightedChoice<Quality>(Quality.DIAMOND, 5));
                    break;
                }
                case 4: {
                    tool.add(new WeightedChoice<Quality>(Quality.WOOD, 1));
                    tool.add(new WeightedChoice<Quality>(Quality.STONE, 2));
                    tool.add(new WeightedChoice<Quality>(Quality.IRON, 10));
                    tool.add(new WeightedChoice<Quality>(Quality.GOLD, 3));
                    tool.add(new WeightedChoice<Quality>(Quality.DIAMOND, 5));
                }
            }
            toolQuality.put(i, tool);
        }
    }

    public static Quality rollToolQuality(Random rand, int level) {
        return toolQuality.get(level).get(rand);
    }

    @Override
    public ItemStack getLootItem(Random random, int level) {
        if (this.type == null) {
            return ItemTool.getRandom(random, level, true);
        }
        ToolType toolType = this.type.asToolType();
        if (toolType == null) {
            return ItemTool.getRandom(random, level, true);
        }
        Quality quality = Optional.ofNullable(this.quality).orElseGet(() -> Quality.get(level));
        Item toolItem = toolType.asItem(quality);
        ItemStack toolItemStack = new ItemStack(toolItem);
        if (this.enchant) {
            return Enchant.enchantItem(random, toolItemStack, Enchant.getLevel(random, level));
        }
        return toolItemStack;
    }

    public static ItemStack getRandom(Random random, int level, boolean enchant) {
        if (enchant && random.nextInt(20 + level * 10) == 0) {
            return SpecialTool.createTool(random, level);
        }
        boolean shouldEnchant = enchant && random.nextInt(6 - level) == 0;
        ToolType toolType = ToolType.random(random);
        Quality quality = ItemTool.rollToolQuality(random, level);
        Item toolItem = toolType.asItem(quality);
        ItemStack toolItemStack = new ItemStack(toolItem);
        if (shouldEnchant) {
            return Enchant.enchantItem(random, toolItemStack, Enchant.getLevel(random, level));
        }
        return toolItemStack;
    }

    static {
        ItemTool.loadToolQualityOddsTable();
    }
}

