/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import greymerk.roguelike.worldgen.Coord;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockLever;
import net.minecraft.util.EnumFacing;

public enum Direction {
    NORTH(EnumFacing.SOUTH, BlockLever.EnumOrientation.SOUTH, 0, 0, -1),
    EAST(EnumFacing.WEST, BlockLever.EnumOrientation.WEST, 1, 0, 0),
    SOUTH(EnumFacing.NORTH, BlockLever.EnumOrientation.NORTH, 0, 0, 1),
    WEST(EnumFacing.EAST, BlockLever.EnumOrientation.EAST, -1, 0, 0),
    UP(EnumFacing.UP, BlockLever.EnumOrientation.UP_X, 0, 1, 0),
    DOWN(EnumFacing.DOWN, BlockLever.EnumOrientation.DOWN_X, 0, -1, 0);

    private final EnumFacing facing;
    private final BlockLever.EnumOrientation orientation;
    private final int xDelta;
    private final int yDelta;
    private final int zDelta;
    public static List<Direction> CARDINAL;

    private Direction(EnumFacing facing, BlockLever.EnumOrientation orientation, int xDelta, int yDelta, int zDelta) {
        this.facing = facing;
        this.orientation = orientation;
        this.xDelta = xDelta;
        this.yDelta = yDelta;
        this.zDelta = zDelta;
    }

    public static Direction randomCardinal(Random random) {
        return CARDINAL.get(random.nextInt(CARDINAL.size()));
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public BlockLever.EnumOrientation getOrientation() {
        return this.orientation;
    }

    public static Set<Direction> cardinals() {
        return Sets.newHashSet(CARDINAL);
    }

    public Coord translate(Coord coord) {
        return coord.translate(this.xDelta, this.yDelta, this.zDelta);
    }

    public Coord translate(Coord coord, int magnitude) {
        return coord.translate(this.xDelta * magnitude, this.yDelta * magnitude, this.zDelta * magnitude);
    }

    public Direction reverse() {
        switch (this) {
            case NORTH: {
                return SOUTH;
            }
            case EAST: {
                return WEST;
            }
            case WEST: {
                return EAST;
            }
            case SOUTH: {
                return NORTH;
            }
            case UP: {
                return DOWN;
            }
        }
        return UP;
    }

    public Direction antiClockwise() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        return this;
    }

    public Direction clockwise() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        return this;
    }

    public Direction back() {
        return this.reverse();
    }

    public Direction left() {
        return this.antiClockwise();
    }

    public Direction right() {
        return this.clockwise();
    }

    public Direction[] orthogonals() {
        return new Direction[]{this.antiClockwise(), this.clockwise()};
    }

    static {
        CARDINAL = Collections.unmodifiableList(Lists.newArrayList((Object[])new Direction[]{NORTH, EAST, SOUTH, WEST}));
    }
}

