/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class RayTraceTools {
    public static void rayTrace(Beam beam, Function<Entity, Boolean> consumer) {
        Vec3d start = beam.getStart();
        Vec3d lookVec = beam.getLookVec();
        Vec3d end = beam.getEnd();
        double dist = beam.getDist();
        World world = beam.getWorld();
        EntityPlayer player = beam.getPlayer();
        List targets = world.func_175674_a((Entity)player, player.func_174813_aQ().func_72321_a(lookVec.field_72450_a * dist, lookVec.field_72448_b * dist, lookVec.field_72449_c * dist).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent != null && ent.func_70067_L()));
        ArrayList<Pair> hitTargets = new ArrayList<Pair>();
        for (Entity target : targets) {
            double d3;
            AxisAlignedBB targetBB = target.func_174813_aQ().func_186662_g((double)target.func_70111_Y());
            if (targetBB.func_72318_a(start)) {
                hitTargets.add(Pair.of((Object)target, (Object)0.0));
                continue;
            }
            RayTraceResult targetResult = targetBB.func_72327_a(start, end);
            if (targetResult == null || !((d3 = start.func_72438_d(targetResult.field_72307_f)) < dist)) continue;
            hitTargets.add(Pair.of((Object)target, (Object)d3));
        }
        hitTargets.sort(Comparator.comparing(Pair::getRight));
        hitTargets.stream().filter(pair -> (Boolean)consumer.apply((Entity)pair.getLeft())).findFirst();
    }

    public static class Beam {
        private World world;
        private EntityPlayer player;
        private double maxDist;
        private Vec3d start;
        private Vec3d lookVec;
        private Vec3d end;
        private double dist;

        public Beam(World world, EntityPlayer player, double maxDist) {
            this.world = world;
            this.player = player;
            this.maxDist = maxDist;
            this.calculate();
        }

        private void calculate() {
            this.start = this.player.func_174824_e(1.0f);
            this.lookVec = this.player.func_70040_Z();
            this.end = this.start.func_72441_c(this.lookVec.field_72450_a * this.maxDist, this.lookVec.field_72448_b * this.maxDist, this.lookVec.field_72449_c * this.maxDist);
            RayTraceResult result = this.world.func_72933_a(this.start, this.end);
            this.dist = this.maxDist;
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.dist = result.field_72307_f.func_72438_d(this.start);
                this.end = this.start.func_72441_c(this.lookVec.field_72450_a * this.dist, this.lookVec.field_72448_b * this.dist, this.lookVec.field_72449_c * this.dist);
            }
        }

        public Vec3d getStart() {
            return this.start;
        }

        public Vec3d getLookVec() {
            return this.lookVec;
        }

        public Vec3d getEnd() {
            return this.end;
        }

        public double getDist() {
            return this.dist;
        }

        public World getWorld() {
            return this.world;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public double getMaxDist() {
            return this.maxDist;
        }
    }
}

