/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.world.gen;

import com.google.common.base.Predicate;
import com.stal111.forbidden_arcanus.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0 || world.field_73011_w.getDimension() < -1) {
            this.runGenerator(ModBlocks.arcane_crystal_ore.func_176223_P(), 5, 3, 8, 18, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, random, chunkX, chunkZ);
            this.runGenerator(ModBlocks.dark_stone.func_176223_P(), 15, 75, 0, 7, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, random, chunkX, chunkZ);
            this.runGenerator(ModBlocks.dark_runestone.func_176223_P(), 2, 9, 3, 6, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, random, chunkX, chunkZ);
            this.runGenerator(ModBlocks.runestone.func_176223_P(), 4, 3, 10, 20, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, random, chunkX, chunkZ);
        }
    }

    private void runGenerator(IBlockState blockToGen, int blockAmount, int chancesToSpawn, int minHeight, int maxHeight, Predicate<IBlockState> blockToReplace, World world, Random rand, int chunk_X, int chunk_Z) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        WorldGenMinable generator = new WorldGenMinable(blockToGen, blockAmount, blockToReplace);
        int heightdiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightdiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

